import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavbarBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mParentTabPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/RouteNavFCM.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Rekap/halamanRekap.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'Template/dialog/dialogConfirmation.dart';
import 'Template/style.dart';
import 'Modul/Dashboard/halamanDashboard.dart';

class ParentTab extends StatefulWidget {
  @override
  _ParentTabState createState() => _ParentTabState();
}

class _ParentTabState extends State<ParentTab> {
  String? routenya;

  final _listPage = <Widget>[
    HalamanDashboard(),
    HalamanRekap(),
  ];

  @override
  void initState() {
    FirebaseMessaging.instance
        .getInitialMessage()
        .then((RemoteMessage? message) {
      if (message != null)
        RouteForegroundBackground(
            message.data['route_nav'], message.data['id_ref']);
    });
    super.initState();
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageParentTabModel>(
        future: PengaturanBahasa().parentTab(),
        builder: (context, snapshot) {
          if (snapshot.connectionState == ConnectionState.done) {
            return BlocBuilder<NavbarBloc, int>(
              builder: (BuildContext context, int index) {
                Future<bool> keluar() async {
                  if (index == 0) {
                    showDialog(
                      barrierDismissible: false,
                      context: context,
                      builder: (BuildContext context) => AlertConfirmation(
                          message: snapshot.data!.parentTab!.messageExit!,
                          textBtnCancel:
                              snapshot.data!.parentTab!.textBtnCancel!,
                          textBtnSubmit:
                              snapshot.data!.parentTab!.textBtnSubmit!,
                          onClick: () {
                            SystemNavigator.pop();
                          }),
                    );
                  } else {
                    BlocProvider.of<NavbarBloc>(context).add(SetNavbar(0));
                  }
                  return false;
                }

                return BlocBuilder<AuthBloc, LoginRespon>(
                    builder: (BuildContext context, LoginRespon loginRespon) {
                  if (loginRespon != false) {
                    return Scaffold(
                      body: Stack(
                        children: [
                          WillPopScope(
                            onWillPop: keluar,
                            child: Scaffold(
                              body: Stack(
                                children: [
                                  Center(
                                    child: _listPage[index],
                                  ),
                                  loginRespon.dataLogin!.komponenMobile !=
                                              null &&
                                          loginRespon.dataLogin!.komponenMobile!
                                                  .length >
                                              14
                                      ? loginRespon.dataLogin!
                                                  .komponenMobile![14] ==
                                              '1'
                                          ? Positioned(
                                              bottom: 20,
                                              right: 0,
                                              left: 0,
                                              child: Container(
                                                decoration: BoxDecoration(
                                                    boxShadow: [
                                                      BoxShadow(
                                                        color: Colors.grey
                                                            .withOpacity(0.25),
                                                        spreadRadius: 2,
                                                        blurRadius: 5,
                                                        offset: Offset(0,
                                                            1), // changes position of shadow
                                                      ),
                                                    ],
                                                    color: Colors.transparent,
                                                    shape: BoxShape.circle),
                                                width: 70,
                                                height: 70,
                                              ),
                                            )
                                          : Container()
                                      : Container(),
                                ],
                              ),
                            ),
                          ),
                          Positioned(
                            bottom: 0,
                            left: 0,
                            right: 0,
                            child: Container(
                              decoration: BoxDecoration(
                                boxShadow: [
                                  BoxShadow(
                                    color: Colors.grey.withOpacity(0.2),
                                    spreadRadius: 2,
                                    blurRadius: 5,
                                    offset: Offset(
                                        0, 1), // changes position of shadow
                                  ),
                                ],
                              ),
                              width: MediaQuery.of(context).size.width,
                              child: BottomNavigationBar(
                                backgroundColor: Colors.white,
                                items: <BottomNavigationBarItem>[
                                  itemNavBar(
                                      0, snapshot.data!.parentTab), //BERANDA
                                  itemNavBar(
                                      1, snapshot.data!.parentTab), //REKAP
                                ],
                                currentIndex: index,
                                selectedItemColor: CustomStyle.color1,
                                unselectedItemColor: CustomStyle.fontColorGrey,
                                type: BottomNavigationBarType.fixed,
                                onTap: (value) {
                                  BlocProvider.of<NavbarBloc>(context)
                                      .add(SetNavbar(value));
                                },
                              ),
                            ),
                          ),
                          loginRespon.dataLogin!.komponenMobile != null &&
                                  loginRespon
                                          .dataLogin!.komponenMobile!.length >
                                      14
                              ? loginRespon.dataLogin!.komponenMobile![14] ==
                                      '1'
                                  ? Align(
                                      alignment: Alignment.bottomCenter,
                                      child: Container(
                                        decoration: BoxDecoration(
                                            color: Colors.white,
                                            shape: BoxShape.circle),
                                        margin: EdgeInsets.only(bottom: 20),
                                        width: 70.0,
                                        height: 70.0,
                                        padding: EdgeInsets.all(6),
                                        child: GestureDetector(
                                          onTap: () => BlocProvider.of<
                                                  NavigatorBloc>(context)
                                              .add(NavigateToAbsensi(context)),
                                          child: loginRespon.dataLogin!
                                                          .komponenMobile !=
                                                      null &&
                                                  loginRespon
                                                          .dataLogin!
                                                          .komponenMobile!
                                                          .length >
                                                      15
                                              ? loginRespon.dataLogin!
                                                              .komponenMobile![
                                                          15] ==
                                                      '1'
                                                  ? Image.asset(ValueImage
                                                      .iconFingerFlextime)
                                                  : Image.asset(
                                                      ValueImage.fingerScan2)
                                              : Image.asset(
                                                  ValueImage.fingerScan2),
                                        ),
                                      ),
                                    )
                                  : Container()
                              : Container(),
                          loginRespon.dataLogin!.komponenMobile != null &&
                                  loginRespon
                                          .dataLogin!.komponenMobile!.length >
                                      14
                              ? loginRespon.dataLogin!.komponenMobile![14] ==
                                      '1'
                                  ? Positioned(
                                      right: 0,
                                      left: 0,
                                      bottom: 6,
                                      child: Container(
                                          width:
                                              MediaQuery.of(context).size.width,
                                          child: Center(
                                              child: Text(
                                            snapshot.data!.parentTab!.absensi!,
                                            style: TextStyle(
                                                color:
                                                    CustomStyle.fontColorGrey,
                                                fontSize:
                                                    CustomStyle.fontSizeSmall -
                                                        1),
                                          ))),
                                    )
                                  : Container()
                              : Container(),
                        ],
                      ),
                    );
                  } else {
                    return Container();
                  }
                });
              },
            );
          } else {
            return CircularProgressIndicator(
              strokeWidth: 8,
            );
          }
        });
  }

  Widget itemNavBarImage(String image) {
    return Container(
      height: 25,
      width: 25,
      child: Image.asset(image),
    );
  }

  BottomNavigationBarItem itemNavBar(int index, ParentTabData? titleData) {
    Widget thisIcon; //unselected icon
    Widget thisActiveIcon; //selected icon
    String title = '';
    switch (index) {
      case 0: //BERANDA
        {
          thisIcon = itemNavBarImage(ValueImage.iconBeranda);
          thisActiveIcon = itemNavBarImage(ValueImage.iconBerandaAktif);
          title = titleData!.beranda!;
        }
        break;

      case 1: //REKAP
        {
          thisIcon = itemNavBarImage(ValueImage.iconRekap);
          thisActiveIcon = itemNavBarImage(ValueImage.iconRekapAktif);
          title = titleData!.dataAbsensi!;
        }
        break;

      // case 2: //AKTIFITAS
      //   {
      //     thisIcon = itemNavBarImage(ValueImage.iconRekap);
      //     thisActiveIcon = itemNavBarImage(ValueImage.iconRekapAktif);
      //     title = 'Aktifitas';
      //   }
      //   break;
      //
      // case 3: //AKUN
      //   {
      //     thisIcon = itemNavBarImage(ValueImage.iconAkun);
      //     thisActiveIcon = itemNavBarImage(ValueImage.iconAkunAktif);
      //     title = 'Akun';
      //   }
      //   break;

      default:
        {
          thisIcon = itemNavBarImage(ValueImage.iconBeranda);
          thisActiveIcon = itemNavBarImage(ValueImage.iconBerandaAktif);
          title = titleData!.absensi!;
        }
        break;
    }
    return BottomNavigationBarItem(
        icon: thisIcon, activeIcon: thisActiveIcon, label: title.toUpperCase());
  }
}
