import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';

class IconInformation extends StatelessWidget {
  String? icon, title, subtitle, content;
  double? sizeIcon;
  bool enableSubTitle;
  var contentColor;
  Widget? rightOptionalWidget;

  IconInformation({this.icon, this.title, this.subtitle, this.sizeIcon, this.enableSubTitle=true, this.rightOptionalWidget, this.content, this.contentColor});

  @override
  Widget build(BuildContext context) {
    return ConstrainedBox(
      constraints: BoxConstraints(
        minHeight: 40
      ),
      child: Row(
        children: [
          Expanded(
            flex: 1,
            child: Container(
              width: sizeIcon,
              height: sizeIcon,
              child: Image.asset(icon!,color: Colors.indigo,),
            ),
          ),
          SizedBox(
            width: 10,
          ),
          Expanded(
            flex: 5,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(
                  title!,
                  overflow: TextOverflow.ellipsis,
                  style: TextStyle(
                      fontSize: CustomStyle.fontSizeSmall, color: CustomStyle.fontColorGrey),
                ),
                SizedBox(height: 2,),
                enableSubTitle
                    ? Text(subtitle!,
                    style: TextStyle(
                        fontSize: CustomStyle.fontSizeSmall-1,
                        color: CustomStyle.fontColorBlack,
                        fontWeight: FontWeight.w600))
                    : Container(),
                // Text(
                //   subtitle!,
                //   // overflow: TextOverflow.ellipsis,
                //   style: TextStyle(
                //       fontSize: CustomStyle.fontSizeSmall-1,
                //       color: CustomStyle.fontColorBlack,
                //       fontWeight: FontWeight.w600),
                // ),
                content!=null?Column(
                  children: [
                    SizedBox(height: 2,),
                    Text(
                      content!,
                      // overflow: TextOverflow.ellipsis,
                      style: TextStyle(
                          fontSize: CustomStyle.fontSizeSmall-1,
                          color: contentColor??CustomStyle.fontColorBlack,
                          fontWeight: FontWeight.w600),
                    ),
                  ],
                ):Container(),
              ],
            ),
          ),
          rightOptionalWidget??Container()
        ],
      ),
    );
  }
}
