import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class TemplateConfirmationDialogV2 {
  String title;
  var action;
  BuildContext context;
  Widget? addWidget;
  double marginHeight;
  Widget? icon;
  TemplateConfirmationDialogV2(this.title, this.action, this.context,
      {this.addWidget, this.marginHeight = 0, this.icon}) {
    showDialog(
        context: context,
        builder: (BuildContext context) {
          return FutureBuilder(
          future: PengaturanBahasa().getDataBahasa(),
          builder: (BuildContext context, snapshot) {
          if (snapshot.connectionState == ConnectionState.done) {
          return AlertDialog(
            shape: RoundedRectangleBorder(
                borderRadius:
                    BorderRadius.all(Radius.circular(CustomStyle.boxRadius))),
            content: Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                icon != null ? icon! : Container(),
                Center(
                  child: Text(
                    title,
                    style: TextStyle(
                        fontSize: CustomStyle.fontSizeNormal,
                        fontWeight: FontWeight.w600),
                  ),
                ),
                addWidget != null
                    ? Container(
                        margin: EdgeInsets.symmetric(vertical: 12),
                        child: addWidget,
                      )
                    : Container(),
                SizedBox(height: marginHeight),
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Expanded(
                      child: TemplateButton(
                        onClick: () => BlocProvider.of<NavigatorBloc>(context)
                            .add(NavigatePop(context)),
                        label: snapshot.data =='id'?"Tidak":"No",
                        color: Colors.transparent,
                        radius: CustomStyle.boxRadius + 4,
                        borderColor: CustomStyle.color1,
                        contentColor: CustomStyle.color1,
                        fontSize: CustomStyle.fontSizeNormal,
                        bold: true,
                      ),
                    ),
                    SizedBox(
                      width: 10,
                    ),
                    Expanded(
                      child: TemplateButton(
                        onClick: action,
                        label: snapshot.data =='id'?"Ya":"Yes",
                        color: CustomStyle.color1,
                        radius: CustomStyle.boxRadius + 4,
                        contentColor: Colors.white,
                        fontSize: CustomStyle.fontSizeNormal,
                        bold: true,
                      ),
                    )
                  ],
                )
              ],
            ),
          );
          } else {
          return Container();
          }},);
          
        
        });
  }
}
