import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownEvent {}

class SelectDataDepartemen extends DropdownEvent {
  DataDropdown? selectedValue;
  SelectDataDepartemen(this.selectedValue);
}

abstract class DepartemenSelectedState {}

class DepartemenSelectedInitial extends DepartemenSelectedState {}

class DepartemenSelectedSuccessState extends DepartemenSelectedState {
  DataDropdown? selectedValue;
  DepartemenSelectedSuccessState(this.selectedValue);
}

class DropdownErrorState extends DepartemenSelectedState {}

class DepartemenSelectedBloc extends Bloc<DropdownEvent, DepartemenSelectedState> {
  DataDropdown? selectedValue;
  DepartemenSelectedBloc(DepartemenSelectedState initialState) : super(initialState);
  @override
  Stream<DepartemenSelectedState> mapEventToState(DropdownEvent event) async* {
    if (event is SelectDataDepartemen) {
      selectedValue = event.selectedValue;
      yield DepartemenSelectedSuccessState(selectedValue);
    }
  }
}
