import 'dart:convert';
import 'dart:io';
import 'package:absenkuv3/UI/Template/Camera/Bloc/CameraBloc.dart';
import 'package:absenkuv3/UI/Template/Camera/Model/CameraModel.dart';
import 'package:absenkuv3/UI/Template/Camera/UI/HalamanCamera.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel2.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:image_picker/image_picker.dart';

abstract class MultiImagePicker2Event{}

class PickImage2 extends MultiImagePicker2Event{
  BuildContext? context;
  bool fromCamera;
  String pluginCamera;
  String defaultCamera;
  PickImage2(context, {this.fromCamera=false, this.defaultCamera='front', this.pluginCamera='1'});
}

class PickImageSingle2 extends MultiImagePicker2Event{
  BuildContext context;
  bool fromCamera;
  String pluginCamera;
  String defaultCamera;
  PickImageSingle2(this.context, {this.fromCamera=false, this.defaultCamera='front', this.pluginCamera='1'});
}

class DeleteImage2 extends MultiImagePicker2Event{
  MultiImagePickerModel2 data;
  DeleteImage2(this.data);
}

abstract class MultiImagePicker2State{}

class MultiImageSuccess2State extends MultiImagePicker2State{
  List<MultiImagePickerModel2> listData;
  MultiImageSuccess2State(this.listData);
}

class MultiImage2ProgressState extends MultiImagePicker2State{}

class MultiImagePicker2Bloc extends Bloc<MultiImagePicker2Event, MultiImagePicker2State>{
  MultiImagePicker2Bloc(MultiImagePicker2State initialState) : super(initialState);
  List<MultiImagePickerModel2> listData = <MultiImagePickerModel2>[];


  @override
  Stream<MultiImagePicker2State> mapEventToState(MultiImagePicker2Event event) async*{
    // TODO: implement mapEventToState
    if(event is PickImage2){
      if(event.fromCamera && event.pluginCamera=='1'){//MASUK KE HALAMAN PLUGIN CAMERA
        CameraModel? cameraModel = await Navigator.push<
            CameraModel>(
            event.context!,
            MaterialPageRoute(
              builder: (_) => BlocProvider(
                create: (BuildContext context) => CameraBloc(InitializeCameraProgress()),
                child: CameraApp('Ambil Foto', false, defaultCamera: event.defaultCamera,),
              ),
            ));
        listData.add(MultiImagePickerModel2(base64Encode(File(cameraModel!.path).readAsBytesSync()), cameraModel.path));
      }
      else{
        final picker = ImagePicker();
        final pickedFile = await picker.pickImage(source: event.fromCamera?ImageSource.camera:ImageSource.gallery, imageQuality: 20);
        if(pickedFile!=null)listData.add(MultiImagePickerModel2(base64Encode(File(pickedFile.path).readAsBytesSync()), pickedFile.path));
      }
      yield MultiImageSuccess2State(listData);
    }
    else if(event is PickImageSingle2){
      if(event.fromCamera && event.pluginCamera=='1'){//MASUK KE HALAMAN PLUGIN CAMERA
        CameraModel? cameraModel = await Navigator.push<
            CameraModel>(
            event.context,
            MaterialPageRoute(
              builder: (_) => BlocProvider(
                create: (BuildContext context) => CameraBloc(InitializeCameraProgress()),
                child: CameraApp('Ambil Foto', false, defaultCamera: event.defaultCamera,),
              ),
            ));
        if(cameraModel!=null) {
          listData.clear();
          listData.add(MultiImagePickerModel2(base64Encode(File(cameraModel.path).readAsBytesSync()), cameraModel.path));
        }
      }
      else{
        final picker = ImagePicker();
        final pickedFile = await picker.pickImage(source: event.fromCamera?ImageSource.camera:ImageSource.gallery, imageQuality: 20);
        if(pickedFile!=null)
          listData.add(MultiImagePickerModel2(base64Encode(File(pickedFile.path).readAsBytesSync()), pickedFile.path));
      }
      if(listData.length>0) yield MultiImageSuccess2State(listData);
    }
    else if(event is DeleteImage2){
      listData.remove(event.data);
      yield MultiImageSuccess2State(listData);
    }
  }

}