import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class ToogleFilterEvent {
  BuildContext? context;
  String? toogle;
}

class InitStateEvent extends ToogleFilterEvent {
  InitStateEvent(BuildContext _context) {
    context = _context;
  }
}

class InitWithValueStateEvent extends ToogleFilterEvent {
  String? toogle;
  InitWithValueStateEvent(BuildContext _context, String? _toogle) {
    context = _context;
    toogle  = _toogle;
  }
}

class ProgressStateEvent extends ToogleFilterEvent {
  ProgressStateEvent(BuildContext _context) {
    context = _context;
  }
}

class ChangeEvent extends ToogleFilterEvent {
  ChangeEvent(BuildContext _context, String _toogle) {
    context = _context;
    toogle = _toogle;
  }
}

abstract class ToogleFilterState {
  late BuildContext context;
  late String toogleChange;
}

class SuccessToogleChangeState extends ToogleFilterState {
  SuccessToogleChangeState(BuildContext _context, String _change) {
    context = _context;
    toogleChange = _change;
  }
}

class ToogleFilterBloc
    extends Bloc<ToogleFilterEvent, ToogleFilterState?> {
  ToogleFilterBloc() : super(null);
  @override
  Stream<SuccessToogleChangeState> mapEventToState(
      ToogleFilterEvent event) async* {
    if (event is InitStateEvent) {
      yield SuccessToogleChangeState(event.context!, 'Semua Tanggal Pengajuan');
    } else if (event is ChangeEvent) {
      yield SuccessToogleChangeState(event.context!, event.toogle!);
    } else if (event is InitWithValueStateEvent){
      yield SuccessToogleChangeState(event.context!, event.toogle!);
    } else {
      yield SuccessToogleChangeState(event.context!, 'Semua Tanggal Pengajuan');
    }
  }
}
