import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/UI/Template/FilterToggle/Bloc/ToogleFilterBloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/DropdownCabangBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/DropdownDepartemenBloc.dart' as departemen;
import 'package:absenkuv3/Bloc/Dropdown/DropdownKaryawanBloc.dart' as karyawan;
import 'package:absenkuv3/Bloc/FilterBottomSheetBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/UI/Template/FilterHeaderChip/CabangHeaderChip.dart';
import 'package:absenkuv3/UI/Template/FilterHeaderChip/DateHeaderChip.dart';
import 'package:absenkuv3/UI/Template/FilterHeaderChip/DepartemenHeaderChip.dart';
import 'package:absenkuv3/UI/Template/FilterHeaderChip/KaryawanHeaderChip.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart'
    as dateRangePicker;
import 'package:absenkuv3/UI/Template/MonthPicker/Bloc/MonthPickerBloc.dart'
    as monthPicker;

class FilterHeaderSheet extends StatefulWidget {
  const FilterHeaderSheet({super.key});

  @override
  State<FilterHeaderSheet> createState() => _FilterHeaderSheetState();
}

class _FilterHeaderSheetState extends State<FilterHeaderSheet> {
  DataDropdown? dataCabang;
  DataDropdown? dataPegawai;
  DataDropdown? dataDepartemen;
  ModelFilter? modelFilter;

  @override
  void initState() {
    super.initState();
    _initializeBlocs();
  }

  void _initializeBlocs() {
    final context = this.context;
    BlocProvider.of<DropdownCabangBloc>(context).add(GetDataDropdown());
    BlocProvider.of<departemen.DropdownDepartemenBloc>(context).add(departemen.GetDataDropdown());
    BlocProvider.of<karyawan.DropdownKaryawanBloc>(context).add(karyawan.GetDataDropdown(null));
    BlocProvider.of<monthPicker.MonthPickerBloc>(context).add(monthPicker.SetDate(null));
    BlocProvider.of<dateRangePicker.DateRangePickerBloc>(context).add(dateRangePicker.InitialDate());
    BlocProvider.of<ToogleFilterBloc>(context).add(InitStateEvent(context));
  }

  void _resetFilters() {
    BlocProvider.of<DropdownCabangBloc>(context).add(SelectDataDropdown(null));
    BlocProvider.of<departemen.DropdownDepartemenBloc>(context).add(departemen.SelectDataDropdown(null));
    BlocProvider.of<karyawan.DropdownKaryawanBloc>(context).add(karyawan.SelectDataDropdown(null));
    BlocProvider.of<dateRangePicker.DateRangePickerBloc>(context).add(dateRangePicker.InitialDate());
    modelFilter = ModelFilter(idCabang: dataCabang?.id);
    BlocProvider.of<FilterBottomSheetBloc>(context).add(setFilterBottomSheet(modelFilter));
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<AuthBloc, LoginRespon>(
      builder: (BuildContext context, LoginRespon loginRespon) {
        return SingleChildScrollView(
          scrollDirection: Axis.horizontal,
          child: Row(
            children: [
              _buildFilterChips(),
              if (_shouldShowCabangChip(loginRespon)) _buildCabangChip(),
              if (_shouldShowDepartemenChip(loginRespon)) _buildDepartemenChip(),
              _buildKaryawanChip(),
              DateHeaderChip(),
            ],
          ),
        );
      },
    );
  }

Widget _buildFilterChips() {
    return BlocBuilder<DropdownCabangBloc, DropdownState>(
      builder: (context, state1) {
        if (state1 is DropdownSuccessState) {
          return BlocBuilder<departemen.DropdownDepartemenBloc, departemen.DropdownState>(
            builder: (context, state2) {
              if (state2 is departemen.DropdownSuccessState) {
                return BlocBuilder<karyawan.DropdownKaryawanBloc, karyawan.DropdownState>(
                  builder: (context, state3) {
                    if (state3 is karyawan.DropdownSuccessState) {
                      return BlocBuilder<dateRangePicker.DateRangePickerBloc, dateRangePicker.DateRangePickerState>(
                        builder: (context, dateRangePickerState) {
                          final bool hasSelection = state1.selectedValue != null ||
                              state2.selectedValue != null ||
                              state3.selectedValue != null ||
                              (dateRangePickerState is dateRangePicker.DateAvailable && dateRangePickerState.date[0] != null);

                          return hasSelection
                              ? GestureDetector(
                                  onTap: _resetFilters,
                                  child: Chip(label: Icon(Icons.close)),
                                )
                              : Container();
                        },
                      );
                    }
                    return Container();
                  },
                );
              }
              return Container();
            },
          );
        }
        return Container();
      },
    );
  }

  bool _shouldShowCabangChip(LoginRespon loginRespon) {
    return loginRespon.dataLogin!.level == 1 ||
        loginRespon.dataLogin!.level == 4 ||
        loginRespon.dataLogin!.level == 5;
  }

  Widget _buildCabangChip() {
    return BlocListener<DropdownCabangBloc, DropdownState>(
      listener: (context, state) {
        if (state is DropdownSuccessState) {
          dataCabang = state.selectedValue;
        }
      },
      child: CabangHeaderChip(),
    );
  }

  bool _shouldShowDepartemenChip(LoginRespon loginRespon) {
    return loginRespon.dataLogin!.level == 1 ||
        loginRespon.dataLogin!.level == 2 ||
        loginRespon.dataLogin!.level == 4 ||
        loginRespon.dataLogin!.level == 5;
  }

  Widget _buildDepartemenChip() {
    return BlocListener<departemen.DropdownDepartemenBloc, departemen.DropdownState>(
      listener: (context, state) {
        if (state is departemen.DropdownSuccessState) {
          BlocProvider.of<karyawan.DropdownKaryawanBloc>(context).add(
            karyawan.GetDataDropdown(
              ModelFilter(idCabang: dataCabang?.id, idDepartemen: state.selectedValue?.id),
            ),
          );
          dataDepartemen = state.selectedValue;
        }
      },
      child: DepartemenHeaderChip(),
    );
  }

  Widget _buildKaryawanChip() {
    return BlocListener<karyawan.DropdownKaryawanBloc, karyawan.DropdownState>(
      listener: (context, state) {
        if (state is karyawan.DropdownSuccessState) {
          dataPegawai = state.selectedValue;
        }
      },
      child: KaryawanHeaderChip(),
    );
  }
}
