import 'package:absenkuv3/UI/Template/DatePicker/Bloc/DatePickerTglLahirBloc.dart';
import 'package:absenkuv3/UI/Template/templateTextFormAkun.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

// ignore: must_be_immutable
class TemplateDatePickerTanggalAktivitas extends StatefulWidget {
  DateTime? initialData;
  double height;
  String title;
  double marginHorizontal;
  TextEditingController? textEditingController;
  TemplateDatePickerTanggalAktivitas(this.title,{this.initialData, this.height = 46, this.marginHorizontal = 0, this.textEditingController});

  @override
  _TemplateDatePickerTanggalAktivitasState createState() => _TemplateDatePickerTanggalAktivitasState();
}

class _TemplateDatePickerTanggalAktivitasState extends State<TemplateDatePickerTanggalAktivitas> {
  DateTime selectedDate = DateTime.now();
  // final dateFormat = new DateFormat('dd-MM-yyyy');
  final dateFormat = DateFormat('d MMMM yyyy', 'id_ID');

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<DatePickerTglLahirBloc, DateTime>(
      builder: (BuildContext context, DateTime date){
        return GestureDetector(
          onTap: () async{
            final DateTime? picked = await showDatePicker(
                context: context,
                initialDate: DateFormat('yyyy-MM-dd').format(DateTime(date.year,date.month,date.day)) == "0001-01-01" ? DateTime.now() : date,
                firstDate: DateTime(1920, 1),
                lastDate: DateTime(2101));
            if (picked != null && picked != selectedDate) BlocProvider.of<DatePickerTglLahirBloc>(context).add(SetDate(picked));
          },
          child: Container(
            child: TemplateTextFormAkun(
              // marginHorizontal: EdgeInsets.only(left: widget.marginHorizontal, right: widget.marginHorizontal),
              // bottomMargin: 0,
              enabled: false,
              suffixIcon: Container(
                margin: EdgeInsets.only(right: 15),
                  child: Icon(Icons.calendar_today, size: 20)),
              fontSize: 13,
              adaValidasi: true,
              controller: widget.textEditingController,
              titleText:widget.title,
              // marginHorizontal: widget.marginHorizontal,
              hintText: DateFormat('yyyy-MM-dd').format(DateTime(date.year,date.month,date.day))=="0001-01-01"
                          ? widget.initialData == null
                            ? widget.title
                            : dateFormat.format(widget.initialData!)
                          :dateFormat.format(date),
              // radius: 6,
              flagColorBackground: false,
              color: Colors.black),
          ),
        );
        // else return Container();
      },
    );
  }
}
