import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';

abstract class TemplateTimePickerEvent{}

class GetCurrentTime extends TemplateTimePickerEvent{}

class InitStateTime extends TemplateTimePickerEvent{}

class SetTime extends TemplateTimePickerEvent{
  TimeOfDay time;
  SetTime(this.time);
}

class TemplateTimePickerBloc extends Bloc<TemplateTimePickerEvent, TimeOfDay>{
  TimeOfDay? time;
  TemplateTimePickerBloc(TimeOfDay initialState) : super(initialState);

  @override
  Stream<TimeOfDay> mapEventToState(TemplateTimePickerEvent event) async*{
    // TODO: implement mapEventToState
    if(event is GetCurrentTime) time = TimeOfDay.now();
    else if(event is InitStateTime) time = null;
    else if(event is SetTime) {
      time = event.time;
    }
    yield time!;
  }
}