import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownJenisStatusBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BaseBottomSheet.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

class BottomSheetJenisStatus extends StatelessWidget {
  final String title;
  final Color color;
  final double? fontSize;
  final String? initialData;
  final double? formHeight;
  final double marginHorizontal;
  late TextEditingController _controller;

  BottomSheetJenisStatus(
    this.title, {
    this.initialData,
    this.color = Colors.grey,
    this.fontSize = 14,
    this.formHeight,
    this.marginHorizontal = 0,
  }) {
    _controller = TextEditingController(text: initialData);
  }

  @override
  Widget build(BuildContext context) {
    return BaseBottomSheet<JenisData, DropdownJenisStatusBloc,
        DropdownJenisStatusState>(
      title: title,
      bloc: context.read<DropdownJenisStatusBloc>(),
      fetchEvent: (bloc) => bloc.add(GetDataDropdownJenisStatus()),
      selectEvent: (bloc, selectedItem) {
        _controller.text = selectedItem.nama ?? '';
        bloc.add(SelectDataDropdownJenisStatus(selectedItem));
      },
      itemTitle: (item) => item.nama ?? '',
      initialData: initialData,
      formHeight: formHeight,
      marginHorizontal: marginHorizontal,
      builder: (context, state, showModal) {
        if (state is DropdownJenisStatusSuccessState) {
          return InkWell(
            onTap: () => showModal(context, state.dropdownRespon.data!),
            child: TextFormField(
              enabled: false,
              style: TextStyle(color: Colors.black,fontSize: fontSize),
              controller: _controller,
              decoration: InputDecoration(
                enabledBorder: UnderlineInputBorder(
                  borderSide:
                      BorderSide(color: CustomStyle.colorLineFormTextField),
                ),
                disabledBorder: UnderlineInputBorder(
                  borderSide:
                      BorderSide(color: CustomStyle.colorLineFormDropdown),
                ),
                fillColor: Colors.transparent,
                isDense: true,
                label: Row(
                  children: [
                    Text(
                      title,
                      style: TextStyle(color: Colors.black54, fontSize: fontSize),
                    ),
                    Container(
                      margin: EdgeInsets.only(left: 5),
                      child: Text(
                        "*",
                        style: TextStyle(
                          color: Colors.red,
                          fontWeight: FontWeight.bold,
                          fontSize: 15,
                        ),
                      ),
                    )
                  ],
                ),
                suffixIcon: Icon(Icons.arrow_drop_down_outlined, size: 25),
              ),
            ),
          );
        } else {
          return Container(
            height: formHeight ?? CustomStyle.formHeight,
            width: MediaQuery.of(context).size.width,
            child: Shimmer.fromColors(
              baseColor: Colors.grey[200]!,
              highlightColor: Colors.white,
              period: Duration(seconds: 4),
              child: Card(),
            ),
          );
        }
      },
    );
  }
}
