import 'package:absenkuv3/Repository/Model/SalesActivity/mPerusahaan.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/AutoComplete/Bloc/AutoCompletePerusahaanBloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';
import '../../style.dart';

typedef void DataAutoCompletePerusahaanCallback(String? val, bool? pelangganBaru);

// ignore: must_be_immutable
class AutoCompletePerusahaan extends StatefulWidget {
  DataAutoCompletePerusahaanCallback? dataCallback;
  String? initialData;
  double? formHeight;
  double? radius;
  String? title;
  double? fontSize;
  Icon? prefixIcon;
  AutoCompletePerusahaan({this.dataCallback, this.radius, this.formHeight, this.initialData, this.title, this.prefixIcon, this.fontSize});
  @override
  _AutoCompletePegawaiState createState() => _AutoCompletePegawaiState();
}

class _AutoCompletePegawaiState extends State<AutoCompletePerusahaan> {
  GlobalKey dropdownKey = GlobalKey();
  TextEditingController keyword = new TextEditingController();
  // bool openDropdown = false;
  bool search = true;
  DataPerusahaan? selectedPerusahaan;

  @override
  void initState() {
    super.initState();
    // BlocProvider.of<AutoCompletePerusahaanBloc>(context)
    //     .add(GetPerusahaan(keyword.text, true, selectedPerusahaan));
    keyword.addListener(cariListener);
  }

  cariListener() {
    // if(keyword.text == ){
    // print("hehehe ${selectedPerusahaan}");
    // if(search){
    // }
    // keyword.dispose();
    widget.dataCallback!(keyword.text, true);
    // BlocProvider.of<AutoCompletePerusahaanBloc>(context).add(GetPerusahaan(keyword.text, false, selectedPerusahaan));
      // setState(() {
      //   if(keyword.text!=""&&keyword.text!=null)
      //     openDropdown = true;
      //   else openDropdown = false;
      // });
    // }
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<String>(
        future: PengaturanBahasa().getDataBahasa(),
        builder: (context, snapshot) {
          return Container(
            margin: EdgeInsets.only(bottom: 12),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                BlocBuilder<AutoCompletePerusahaanBloc, AutoCompletePerusahaanState>(
                  builder: (BuildContext context, AutoCompletePerusahaanState state){
                    if(state is GetPerusahaanSuccess) {
                      selectedPerusahaan = state.selectedValue;
                      return Container(
                        child: DropdownMenu(
                          key: dropdownKey,
                          enableSearch: false,
                          dropdownMenuEntries:
                          state.dropdownRespon == null
                            ? <DropdownMenuEntry<DataPerusahaan>>[]
                            : state.dropdownRespon!.data!.map((item) {
                                return DropdownMenuEntry(value: item, label: item.namaPerusahaan!, );
                              }).toList(),
                          inputDecorationTheme: InputDecorationTheme(
                            contentPadding: EdgeInsets.symmetric(vertical: 7.0),
                            enabledBorder: UnderlineInputBorder(borderSide: BorderSide(color: CustomStyle.colorLineFormDropdown)),
                          ),
                          controller: keyword,
                          onSelected: (value) {
                            print("jajaja $value");
                            selectedPerusahaan = value;
                            BlocProvider.of<AutoCompletePerusahaanBloc>(context)
                                .add(SetPerusahaan(value!));
                          },
                          label: Row(
                            children: [
                              Text(widget.title!,
                                  style: TextStyle(
                                      fontSize: widget.fontSize,
                                      fontWeight: FontWeight.w400)),
                              SizedBox(width: 7),
                              Text('*',
                                  style: TextStyle(
                                      color: Colors.red,
                                      fontSize: widget.fontSize)),
                            ],
                          ),
                          textStyle: TextStyle(fontSize: 13),
                          requestFocusOnTap: true,
                          width: MediaQuery.of(context).size.width - 50,
                          // enabled: false,

                        ),
                      );
                    }
                    else {
                      return Container(
                        height: widget.formHeight ?? CustomStyle.formHeight,
                        width: MediaQuery.of(context).size.width,
                        child: Shimmer.fromColors(
                          baseColor: Colors.grey[200]!,
                          highlightColor: Colors.white,
                          period: Duration(seconds: 4),
                          child: Card(),
                        ),
                      );
                    }},
                ),
              ],
            ),
          );
        }
    );



  }
}
