import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/AutoComplete/Bloc/AutoCompletePegawaiBawahanBloc.dart';
import 'package:absenkuv3/UI/Template/templateFormKanban.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../../style.dart';

typedef void AutoCompletePegawaiBawahan2Callback(DataDropdown? val);
// ignore: must_be_immutable
class AutoCompletePegawaiBawahan2 extends StatefulWidget {
  ModelFilter? modelFilter;
  String? initialData;
  double? formHeight;
  double? radius;
  String? title;
  double? fontSize;
  Icon? prefixIcon;
  AutoCompletePegawaiBawahan2Callback? dataCallback;
  AutoCompletePegawaiBawahan2(this.modelFilter,{this.radius, this.formHeight, this.initialData, this.title, this.prefixIcon, this.fontSize, this.dataCallback});
  @override
  _AutoCompletePegawaiBawahan2State createState() => _AutoCompletePegawaiBawahan2State();
}

class _AutoCompletePegawaiBawahan2State extends State<AutoCompletePegawaiBawahan2> {
  TextEditingController keyword = new TextEditingController();
  bool openDropdown = false;
  DataDropdown? selectedPegawai;

  @override
  void initState() {
    super.initState();
    if(widget.modelFilter!.namaPegawai != null){
      keyword.text = widget.modelFilter!.namaPegawai!;
      selectedPegawai = DataDropdown(id: widget.modelFilter!.idPegawai, nama: widget.modelFilter!.namaPegawai);
      keyword.addListener(cariListener);
    }else{
      keyword.addListener(cariListener);
    }

  }

  cariListener() {
    BlocProvider.of<AutoCompletePegawaiBawahanBloc>(context).add(GetPegawaiBawahanNoLoading(keyword.text));
    // setState(() {
        openDropdown = true;
    // });
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<String>(
        future: PengaturanBahasa().getDataBahasa(),
        builder: (context, snapshot) {
          return Container(
              margin: EdgeInsets.only(bottom: 12),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  BlocBuilder<AutoCompletePegawaiBawahanBloc, AutoCompletePegawaiBawahanState>(
                    builder: (BuildContext context, AutoCompletePegawaiBawahanState state){
                      if(state is SetPegawaiBawahanSuccess && state.pegawaiBawahan!=null) {
                        selectedPegawai = state.pegawaiBawahan;
                        return TemplateFormKanban(
                          fontSize:widget.fontSize??null,
                          titleText:widget.title??null,
                          prefixIcon: widget.prefixIcon??null,
                          hintText: selectedPegawai!=null?selectedPegawai!.nama: snapshot.data == null || snapshot.data == 'en' ? "All Sales" : "Semua Sales",
                          controller: keyword,
                          color: CustomStyle.fontColorBlack,
                          formHeight: widget.formHeight,
                          radius: widget.radius,
                          contentPadding: EdgeInsets.fromLTRB(0, 0, 0, 21),
                          bottomMargin: 0,
                          dataCallback: (v){
                            if(v == false){
                              setState(() {
                                openDropdown = false;
                              });
                            }
                          },
                          suffixIcon: GestureDetector(
                              onTap: (){
                                setState(() {
                                  selectedPegawai = null;
                                  keyword.clear();
                                  openDropdown = false;
                                  widget.dataCallback!(null);
                                });
                              },
                              child: Container(
                                  margin: EdgeInsets.only(bottom: 13),
                                  child: Icon(Icons.close, color: Colors.red, size: 22,))),
                        );
                      }
                      else {
                        if(state is SetPegawaiBawahanSuccess && state.pegawaiBawahan == null) {
                          keyword.text = "";
                          openDropdown = false;
                        }
                        if(keyword.text.trim().isEmpty){
                          selectedPegawai = null;
                        }
                        return TemplateFormKanban(
                          fontSize:widget.fontSize??null,
                          titleText:widget.title??null,
                          prefixIcon: widget.prefixIcon??null,
                          hintText: selectedPegawai!=null?selectedPegawai!.nama:snapshot.data == null || snapshot.data == 'en' ? "All Sales" : "Semua Sales",
                          controller: keyword,
                          color: CustomStyle.fontColorBlack,
                          suffixIcon: selectedPegawai!=null
                              ? GestureDetector(
                              onTap: (){
                                setState(() {
                                  selectedPegawai = null;
                                  keyword.clear();
                                  openDropdown = false;
                                  widget.dataCallback!(null);
                                });
                              },
                              child: Container(
                                  margin: EdgeInsets.only(bottom: 13),
                                  child: Icon(Icons.close, color: Colors.red, size: 22,)))
                              : Container(
                              margin: EdgeInsets.only(bottom: 13),
                              child: Icon(Icons.arrow_drop_down)),
                          formHeight: widget.formHeight,
                          radius: widget.radius,
                          contentPadding: EdgeInsets.fromLTRB(0, 0, 0, 21),
                          dataCallback: (v){
                            if(v == false){
                              setState(() {
                                openDropdown = false;
                              });
                            }else{
                              setState(() {
                                openDropdown = true;
                              });
                            }
                          },
                          bottomMargin: 0,);
                      }},
                  ),
                  openDropdown?BlocBuilder<AutoCompletePegawaiBawahanBloc, AutoCompletePegawaiBawahanState>(
                      builder: (BuildContext context, AutoCompletePegawaiBawahanState state){
                        if(state is GetPegawaiBawahanSuccess) return Container(
                          margin: EdgeInsets.only(top: 6),
                          padding: EdgeInsets.fromLTRB(8,4,8,12),
                          decoration: BoxDecoration(
                              boxShadow: [
                                BoxShadow(
                                  color: Colors.grey.withOpacity(0.16),
                                  spreadRadius: 1,
                                  blurRadius: 7,
                                  offset: Offset(0, 1), // changes position of shadow
                                ),
                              ],
                              color: Colors.white,
                              borderRadius: new BorderRadius.all(Radius.circular(0))
                          ),
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: state.listPegawaiBawahan!
                                .map((item) => templateContentAutoComplete(item))
                                .toList(),
                          ),
                        );
                        else if(state is ProgressState) return Container(
                            height: 100,
                            child: Center(child: CircularProgressIndicator(strokeWidth: 8,)));
                        else return Container(
                              height: 100,
                              child: Center(child: Text(snapshot.data == null || snapshot.data == 'en' ? "Sales not found" : "Sales tidak ditemukan", style: TextStyle(fontSize: CustomStyle.fontSizeSmall),),));
                      }):Container(),
                ],
              ),
            );
        }
    );
  
  }

  Widget templateContentAutoComplete(DataDropdown data){
    return GestureDetector(
      onTap: (){
        setState(() {
          keyword.text = data.nama!;
          selectedPegawai = data;
          openDropdown = false;
          widget.dataCallback!(selectedPegawai);
          FocusScopeNode currentFocus = FocusScope.of(context);

          if (!currentFocus.hasPrimaryFocus) {
            currentFocus.unfocus();
          }
        });
      },
      child: Container(
          width: MediaQuery.of(context).size.width,
          decoration: BoxDecoration(
              border: Border(
                bottom: BorderSide( //                   <--- left side
                  color: Colors.grey[300]!,
                  width: 0.5,
                ),
              )),
          padding: EdgeInsets.fromLTRB(14,16,14,16),
          child: Text(data.nama!, style: TextStyle(fontSize: widget.fontSize??CustomStyle.fontSizeSmall),)),
    );
  }
}
