import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mBeritaPengumumanPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Pengumuman/HalamanListPengumuman.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'Modul/Berita/HalamanListBerita.dart';

class ParentTabBeritaPengumuman extends StatefulWidget {
  @override
  State<ParentTabBeritaPengumuman> createState() => _ParentTabBeritaPengumumanState();
}

class _ParentTabBeritaPengumumanState extends State<ParentTabBeritaPengumuman> {
  final int tabLength = 2;

  Future<bool> keluar() async {
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateRemoveToDashboard(context));
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageBeritaPengumumanModel>(
        future: PengaturanBahasa().beritaPengumuman(),
        builder: (context, snapshot){
          if(snapshot.connectionState == ConnectionState.done){
            return BlocBuilder<AuthBloc, LoginRespon>(
                builder: (BuildContext context, LoginRespon loginRespon) {
                  return WillPopScope(
                    onWillPop: keluar,
                    child: DefaultTabController(
                      length: tabLength,
                      child: Scaffold(
                        appBar: AppBar(
                          centerTitle: true,
                          flexibleSpace: Image(
                            image: AssetImage(ValueImage.headerBiruDashboard),
                            fit: BoxFit.cover,
                          ),
                          backgroundColor: Colors.transparent,
                          title: Text(
                            snapshot.data!.menuBeritaPengumuman!.title!,
                            style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                          ),
                          bottom: TabBar(
                            labelPadding: EdgeInsets.all(0),
                            indicatorSize: TabBarIndicatorSize.tab,
                            indicatorWeight: 4,
                            isScrollable: true,
                            tabs: [
                              Container(
                                width: MediaQuery.of(context).size.width / tabLength,
                                child: Tab(
                                  text: snapshot.data!.menuBeritaPengumuman!.tabBerita,
                                ),
                              ),
                              Container(
                                width: MediaQuery.of(context).size.width / tabLength,
                                child: Tab(
                                  text: snapshot.data!.menuBeritaPengumuman!.tabPengumuman,
                                ),
                              ),
                            ],
                          ),
                        ),
                        body: TabBarView(
                          physics: NeverScrollableScrollPhysics(),
                          children: [
                            HalamanListBerita(),
                            HalamanListPengumuman(),
                          ],
                        ),
                      ),
                    ),
                  );
                });
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
    );
  }
}
