import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/CustomBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/DropdownKlienBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/Sos/SosBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mSosPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/mSos.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Sos/komponen/KomponenSos.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetKlien.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Bloc/MultiImagePickerBloc.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/UI/templateMultiImagePickerV2.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/UI/templateMultiImageSOS.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateTextFormV2.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanPengajuanSos extends StatefulWidget {
  const HalamanPengajuanSos({super.key});

  @override
  State<HalamanPengajuanSos> createState() => _HalamanPengajuanSosState();
}

class _HalamanPengajuanSosState extends State<HalamanPengajuanSos> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  final GlobalKey<FormState> formKey = GlobalKey<FormState>();
  TextEditingController keterangan = new TextEditingController();
  List<MultiImagePickerModel>? listImage;
  JenisData? klien;

  @override
  void initState() {
    // BlocProvider.of<DropdownKlienBloc>(context).add(GetDataDropdowKlien());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageSosModel>(
        future: PengaturanBahasa().sos(),
        builder: (context, snapshot) {
          if (snapshot.connectionState == ConnectionState.done) {
            return Scaffold(
                key: scaffoldKey,
                backgroundColor: Colors.white,
                appBar: AppBar(
                  centerTitle: true,
                  title: Text(
                    snapshot.data!.menuSos!.title!.parentTitle!,
                    style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                  ),
                  actions: [
                    GestureDetector(
                      onTap: () => BlocProvider.of<NavigatorBloc>(context)
                          .add(NavigateToHalamanListSos(context)),
                      child: Container(
                          margin: EdgeInsets.only(right: 14),
                          child: Icon(
                            Icons.list_alt_rounded,
                            size: 26,
                          )),
                    ),
                  ],
                  flexibleSpace: Image(
                    image: AssetImage(ValueImage.headerBiruDashboard),
                    fit: BoxFit.cover,
                  ),
                  backgroundColor: Colors.transparent,
                ),
                body: BlocBuilder<AuthBloc, LoginRespon>(
                    builder: (BuildContext context, LoginRespon loginRespon) {
                  if (loginRespon != false) {
                    return Column(children: [
                      Expanded(
                        child: SingleChildScrollView(
                          padding: EdgeInsets.fromLTRB(14, 24, 14, 18),
                          child: Form(
                              child: Column(
                            children: [
                              loginRespon.dataLogin!.koordinatorKlien == '1' &&
                                      loginRespon.dataLogin!.koordinator ==
                                          '1' &&
                                      loginRespon.dataLogin!.jumlahKlien! > 1
                                  ? BlocListener<DropdownKlienBloc,
                                      DropdownKlienState>(
                                      listener: (BuildContext context,
                                          DropdownKlienState state) {
                                        if (state
                                                is DropdownKlienSuccessState &&
                                            state.selectedValue != null) {
                                          klien = state.selectedValue;
                                        }
                                      },
                                      child: BottomSheetKlien('klien'
                                          // color: Colors.grey[600],
                                          // marginHorizontal: 13,
                                          ),
                                    )
                                  : KlienDropdownTriggerSection(
                                      onSelected: (selected) {
                                        klien = selected;
                                      },
                                    ),
                              TemplateTextFormV2(
                                adaValidasi: true,
                                controller: keterangan,
                                color: Colors.black,
                                maxLine: 5,
                                fontSize: 13,
                                titleText: snapshot
                                    .data!.menuSos!.data!.keterangan
                                    .toString(),
                                radius: CustomStyle.formRadius,
                                // hintText: "Email",
                              ),
                              BlocListener<MultiImagePickerBloc,
                                  MultiImagePickerState>(
                                listener: (BuildContext context,
                                    MultiImagePickerState state) {
                                  if (state is MultiImageSuccessState)
                                    listImage = state.listData;
                                },
                                child: TemplateMultiImageSOS(
                                  fromCamera: true,
                                  defaultCamera: 'back',
                                  maxUpload: 2,
                                ),
                              ),
                              // Text(klien == null ? '' : klien!.nama.toString()),
                              // Text(loginRespon.dataLogin!.idKlien!),
                              ElevatedButton(
                                style: ElevatedButton.styleFrom(
                                  backgroundColor: Colors.black,
                                  foregroundColor: Colors.white,
                                ),
                                onPressed: () {
                                  print(klien == null
                                      ? ''
                                      : klien!.nama.toString());
                                },
                                child: const Text("Save"),
                              ),
                            ],
                          )),
                        ),
                      ),
                      Container(
                        color: Colors
                            .white, // Optional: add background color to the button
                        padding:
                            EdgeInsets.all(14), // Padding around the button
                        child: TemplateButton(
                          onClick: () {
                            String? idKlien;

                            if (loginRespon.dataLogin!.koordinatorKlien ==
                                    '1' &&
                                loginRespon.dataLogin!.koordinator == '1' &&
                                loginRespon.dataLogin!.jumlahKlien! > 1) {
                              if (klien == null) {
                                showSnackBarDelayed(scaffoldKey,
                                    'Pilih klien terlebih dahulu', context);
                                    return ;
                              }else{
                                idKlien=klien!.id;
                              }
                            } else {
                              idKlien = klien == null ? '' : klien!.id;
                            }
                            // print("ini id ${idKlien}");
                            if (keterangan.text.trim().isEmpty) {
                              showSnackBarDelayed(
                                  scaffoldKey,
                                  '${snapshot.data!.menuSos!.pesanKonfirmasi!.ketIsEmpty}',
                                  context);
                            } else if (listImage == null ||
                                listImage!.length == 0) {
                              showSnackBarDelayed(
                                  scaffoldKey,
                                  '${snapshot.data!.menuSos!.pesanKonfirmasi!.fileIsEmpty}',
                                  context);
                            } else {
                              BlocProvider.of<SosBloc>(context).add(
                                  pengajuanSos(
                                      ModelPengajuanSos(
                                          keterangan.text, listImage,idKlien),
                                      context,
                                      scaffoldKey,
                                      formKey));
                            }
                          },
                          radius: CustomStyle.formRadius + 6,
                          label: "Submit",
                          color: CustomStyle.color1,
                          expand: true,
                          bold: true,
                          heightButton: 40,
                        ),
                      ),
                    ]);
                  } else {
                    return Container();
                  }
                }));
          } else {
            return Container();
          }
        });
  }
}
