import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';

class TemplateStepper extends StatelessWidget {
  int currentState;
  TemplateStepper(this.currentState);

  @override
  Widget build(BuildContext context) {
    return  Container(
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          Expanded(
            flex: currentState == 0 ? 3 : 1,
            child: Container(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  Container(
                    margin: EdgeInsets.fromLTRB(27,13,currentState == 0 ? 27 : 20,13),
                    child: Row(
                      mainAxisAlignment: currentState == 0 ? MainAxisAlignment.start : MainAxisAlignment.start,
                      children: [
                        Container(
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              border: Border.all(color: CustomStyle.color1, width: 2),
                              color: CustomStyle.color1
                          ),
                          padding: EdgeInsets.all(7),
                          child: Text('1', style: TextStyle(fontSize: 13, color: Colors.white)),
                        ),
                        currentState == 1 ? Container() :
                        Container(
                          padding: EdgeInsets.symmetric(horizontal: 13),
                          child: Center(child: Text('Data Produk/Layanan', style: TextStyle(fontSize: 14, fontWeight: FontWeight.w600))),
                        )
                      ],
                    ),
                  ),
                  Divider(thickness: 2, height: 1, color: CustomStyle.color1)
                ],
              ),
            ),
          ),
          Expanded(
            flex: currentState == 1 ? 4 : 1,
            child: Container(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  Container(
                    margin: EdgeInsets.fromLTRB(currentState == 1 ? 0 : 27,13,27,13),
                    child: Row(
                      children: [
                        Container(
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              border: Border.all(color: currentState == 1 ? CustomStyle.color1 : Colors.grey.shade400, width: 2),
                              color: currentState == 1 ? CustomStyle.color1 : null
                          ),
                          padding: EdgeInsets.all(7),
                          child: Center(child: Text('2', style: TextStyle(fontSize: 13, color: currentState == 1 ? Colors.white : Colors.grey.shade500))),
                        ),
                        currentState == 0 ? Container() :
                        Container(
                          padding: EdgeInsets.symmetric(horizontal: 13),
                          child: Center(child: Text('Data Pelanggan', style: TextStyle(fontSize: 14, fontWeight: FontWeight.w600))),
                        )
                      ],
                    ),
                  ),
                  Divider(thickness: 2, height: 1, color: currentState == 1 ? CustomStyle.color1 : null)
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }
}
