import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/LayananDraftBloc.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataKanban.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataLayanan.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Kanban/templeteCRUDLayanan.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateConfirmationDialog.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

typedef void DataCardLayananCallback(List val);

class CardLayananPage extends StatefulWidget {
  DataKanban dataKanban;
  Layanan data;
  GlobalKey<ScaffoldState> _scaffoldKey;
  double marginHorizontal;
  bool bottomSheet;
  String page;
  DataCardLayananCallback? dataCallback;
  bool actionEdit;
  CardLayananPage(this.dataKanban, this.data, this._scaffoldKey, this.bottomSheet, this.page, this.actionEdit, {this.marginHorizontal=23, this.dataCallback});

  @override
  State<CardLayananPage> createState() => _CardLayananPageState();
}

class _CardLayananPageState extends State<CardLayananPage> {
  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.fromLTRB(widget.marginHorizontal,0,widget.marginHorizontal,0),
      color: Colors.white,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          SizedBox(height: 7),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text("${widget.data.namaLayanan}", style: TextStyle(fontSize: 14, fontWeight: FontWeight.w500)),
              // Expanded(child: Text("Absenku Andromeda Bimasakti Milkomeda Jaya Jaya Jaya", style: TextStyle(fontSize: 14, fontWeight: FontWeight.w500))),
              !widget.actionEdit ? Container() :
              PopupMenuButton<String>(
                onSelected: (value) => doAction(context, value, widget.data, widget.page),
                itemBuilder: (BuildContext context) {
                  return ['Edit','Hapus'].map((String choice) {
                    return PopupMenuItem<String>(
                      value: choice,
                      child: Text(choice),
                    );
                  }).toList();
                },
                child: Icon(
                  Icons.more_vert_sharp,
                  size: 20,
                  color: Colors.grey.shade600,
                  // color: CustomStyle.fontColorGrey,
                ),
              )
            ],
          ),
          SizedBox(height: 13),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Text("Rp ${widget.data.harga} x ${widget.data.jumlah}", style: TextStyle(fontSize: 12)),
              Text("Rp ${widget.data.jumlahHarga}", style: TextStyle(fontSize: 12)),
            ],
          ),
          widget.data.diskon == "0.00" ? Container() :
          Column(
            children: [
              SizedBox(height: 5),
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Text("      Diskon : ${widget.data.diskon}%", style: TextStyle(fontSize: 12)),
                  Text("Rp ${widget.data.jumlahDiskon}", style: TextStyle(fontSize: 12)),
                ],
              ),
            ],
          ),
          // SizedBox(height: 5),
          Container(height: 7, color: Colors.white),
          // Divider(thickness: 1)
        ],
      ),
    );
  }

  Future doAction(BuildContext context, String value, Layanan jenisProduct, String page) {
    if (value == 'Edit'){
      return TemplateCRUDLayanan().showDialogEditLayanan(context, widget._scaffoldKey, widget.data.idPipelineMain!, widget.data.idPipelineLayanan!, jenisProduct, 'EDIT', widget.bottomSheet, page)
      .then((value){
        if(value == 'refresh'){
          widget.dataCallback!([true,value]);
        }else{
          widget.dataCallback!([false,value]);
        }
      });
    }else{
      return showDialog(
          context: context,
          builder: (BuildContext context) {
            return AlertDialog(
              shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.all(Radius.circular(CustomStyle.boxRadius))
              ),
              content: Column(
                mainAxisSize: MainAxisSize.min,
                children: [
                  Center(child: Text("Apakah Anda yakin akan menghapus layanan ini?", style: TextStyle(fontSize: CustomStyle.fontSizeNormal, fontWeight: FontWeight.w600),),),
                  SizedBox(height: 13),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      TemplateButton(
                        onClick: ()=>BlocProvider.of<NavigatorBloc>(context).add(NavigatePop(context)),
                        label: "Tidak", color: Colors.transparent, contentColor: CustomStyle.color1, fontSize: CustomStyle.fontSizeNormal, bold: true,),
                      TemplateButton(
                        onClick: () {
                          BlocProvider.of<LayananDraftBloc>(context)
                              .add(deleteLayananEvent(context, widget._scaffoldKey, jenisProduct, widget.bottomSheet));
                        },
                        label: "Ya", color: Colors.transparent, contentColor: CustomStyle.color1, fontSize: CustomStyle.fontSizeNormal, bold: true,)
                    ],
                  )
                ],
              ),
            );
          }).then((value) => widget.dataCallback!([true,""]));
    }
  }
}
