import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DataDailyAktivitasSalesBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DetailDailyAktivitasSalesBloc.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDailyActivity.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Izin/HalamanDetailIzin.dart';
import 'package:absenkuv3/UI/Template/halamanDetailMap.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateConfirmationDialog.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

// typedef void DataCallbackDetailDailyActivity(DataDailyAktivitasSales val);

class HalamanDetailDailyActivity extends StatefulWidget {
  var data; // 0: DataDailyAktivitasSales; 1: Status; 2: pegawaiAtasan
  // DataCallbackDetailDailyActivity? dataCallback;
  HalamanDetailDailyActivity(this.data);

  @override
  State<HalamanDetailDailyActivity> createState() => _HalamanDetailDailyActivityState();
}

class _HalamanDetailDailyActivityState extends State<HalamanDetailDailyActivity> {
  String urlFoto = "https://akcdn.detik.net.id/visual/2023/01/02/kebiasaan-mudah-untuk-punya-kulit-glowing-ala-orang-korea_169.jpeg?w=700&q=90";
  bool refresh = false;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DetailDailyAktivitasSalesBloc>(context).add(getListDetailDailyAktivitasSalesEvent(context, widget.data[1], widget.data[0]));
  }

  Future<bool> keluar() async {
    Navigator.pop(context, refresh);
    // if(refresh){
    //   BlocProvider.of<DataDailyAktivitasSalesBloc>(context).add(
    //       getListDataDailyAktivitasSalesOnDetailEvent(context, widget.data[1]));
    // }
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: BlocBuilder<DetailDailyAktivitasSalesBloc, DetailDailyAktivitasSalesState>(
        builder: (context, state) {
          return Scaffold(
            appBar: AppBar(
              centerTitle: true,
              flexibleSpace: Image(
                image: AssetImage(ValueImage.headerBiruDashboard),
                fit: BoxFit.cover,
              ),
              backgroundColor: Colors.transparent,
              title: Text(
                'Detail Activity',
                style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
              ),
              actions: [
                state is getListDetailDailyAktivitasSalesSuccessState
                  ? GestureDetector(
                      onTap: (){
                        Navigator.pushNamed(context, '/edit_sales_activity',
                            arguments: [state.data![0]]);
                      },
                      child: Container(
                        margin: EdgeInsets.only(right: 14),
                        child: Icon(Icons.edit, size: 21,)))
                  : Container()
              ],
            ),
            body: state is getListDetailDailyAktivitasSalesSuccessState
              ? Stack(
              children: [
                Container(
                  height: double.infinity,
                  color: Colors.white,
                  margin: EdgeInsets.only(bottom: state.data![0].button!.buttonApprove! ? 60 : 0),
                  padding: const EdgeInsets.all(22),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Row(
                            children: [
                              Icon(
                                Icons.calendar_month,
                                size: 28,
                              ),
                              SizedBox(
                                width: 8,
                              ),
                              TemplateColumn(
                                title: "Tanggal Pengajuan",
                                value: state.data![0].waktu,
                              ),
                            ],
                          ),
                          TemplateButton(
                            label: state.data![0].status!.status,
                            color: Color(int.parse(state.data![0].status!.color!)),
                            contentColor: Color(int.parse(state.data![0].status!.fontColor!)),
                            fontSize: 14,
                            radius: 2,
                            paddingTopBottom: 4,
                            heightButton: 30,
                            bold: true,
                            paddingLeftRight: 16,
                          ),
                        ],
                      ),
                      SizedBox(
                        height: 16,
                      ),
                      Divider(),
                      widget.data[2]?Column(
                        children: [
                          TemplateColumn(
                            title: "Sales",
                            value: state.data![0].userInput,
                          ),
                          SizedBox(
                            height: 16,
                          ),
                        ],
                      ):Container(),
                      TemplateColumn(
                        title: "Aktivitas",
                        value: state.data![0].aktivitas,
                      ),
                      SizedBox(
                        height: 16,
                      ),
                      TemplateColumn(
                        title: "Pelanggan",
                        value: state.data![0].namaPelanggan,
                      ),
                      SizedBox(
                        height: 16,
                      ),
                      TemplateColumn(
                        title: "Jam",
                        value: state.data![0].jam!.substring(0,5),
                      ),
                      SizedBox(
                        height: 16,
                      ),
                      TemplateColumn(
                        title: "Keterangan",
                        value: state.data![0].ketMove=="" ? state.data![0].keterangan : state.data![0].ketMove,
                      ),
                      SizedBox(
                        height: 16,
                      ),
                      TemplateColumn(
                        title: "Poin",
                        value: state.data![0].point,
                      ),
                      SizedBox(
                        height: 16,
                      ),
                      state.data![0].flagUploadFoto == "1" && state.data![0].flagLokasi == "0"
                          ? Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text("Lampiran",
                            style: TextStyle(
                                fontSize: 12,
                                fontWeight: FontWeight.w400,
                                color: CustomStyle.fontColorGrey),
                          ),
                          SizedBox(
                            height: 8,
                          ),
                          state.data![0].pathFoto != null && state.data![0].pathFoto != "-"
                              ? Wrap(
                              spacing: 8,
                              runSpacing: 4,
                              children: [
                                GestureDetector(
                                    onTap: () => BlocProvider.of<NavigatorBloc>(context)
                                        .add(NavigateToDetailImageClicked(context, state.data![0].pathFoto!)),
                                    child: Image.network(state.data![0].pathFoto!,
                                        width: MediaQuery.of(context).size.width / 4))
                              ]
                          )
                              : Container(
                              width: MediaQuery.of(context).size.width,
                              child: Column(
                                crossAxisAlignment:
                                CrossAxisAlignment.center,
                                children: [
                                  Icon(Icons.image_not_supported,
                                    color: Colors.grey[500],
                                    size: MediaQuery.of(context).size.width / 3.2,),
                                  SizedBox(height: 14),
                                  Text("Tidak Ada Lampiran",
                                      style: TextStyle(
                                          color: CustomStyle.fontColorGrey,
                                          fontSize: CustomStyle.fontSizeSmall,
                                          fontWeight: FontWeight.w400))
                                ],
                              ))
                        ],
                      )
                          : state.data![0].flagLokasi == "1"
                          ? Container(
                        decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(13),
                            border: Border.all()
                        ),
                        child: Row(
                          children: [
                            Container(
                              width: 90,
                              height: 100,
                              decoration: BoxDecoration(
                                color: Colors.grey.shade100,
                                borderRadius: BorderRadius.only(
                                    bottomLeft: Radius.circular(13),
                                    topLeft: Radius.circular(13)
                                ),
                              ),
                              child: state.data![0].flagUploadFoto == "1"
                                  ? ClipRRect(
                                borderRadius: BorderRadius.only(
                                    bottomLeft: Radius.circular(13),
                                    topLeft: Radius.circular(13)
                                ),
                                child: GestureDetector(
                                  onTap: ()=> BlocProvider.of<NavigatorBloc>(context)
                                      .add(NavigateToDetailImageClicked(context, state.data![0].pathFoto!)),
                                  // .add(NavigateToDetailImageClicked(context, urlFoto)),
                                  child: Image.network(state.data![0].pathFoto!,
                                      fit: BoxFit.cover,
                                      errorBuilder: (con, obj, st){
                                        return Icon(
                                          Icons.image_not_supported,
                                          size: 75,
                                          color: Colors.grey,
                                        );
                                      }),
                                ),
                              )
                                  : Icon(
                                Icons.image_not_supported,
                                size: 75,
                                color: Colors.grey,
                              ),
                            ),
                            Expanded(
                              child: Container(
                                margin: EdgeInsets.only(left: 13, right: 13),
                                child: Row(
                                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                  children: [
                                    Expanded(
                                      child: Column(
                                        crossAxisAlignment: CrossAxisAlignment.start,
                                        children: [
                                          Text("Lokasi", style: TextStyle(fontWeight: FontWeight.w400, fontSize: 13)),
                                          SizedBox(height: 5),
                                          Wrap(
                                            children: [
                                              Text(state.data![0].latitude!, style: TextStyle(fontWeight: FontWeight.w700, fontSize: 13)),
                                              SizedBox(width: 3),
                                              Text(",", style: TextStyle(fontWeight: FontWeight.w700, fontSize: 13)),
                                              SizedBox(width: 3),
                                              Text(state.data![0].longitude!, style: TextStyle(fontWeight: FontWeight.w700, fontSize: 13)),
                                              SizedBox(width: 3),
                                            ],
                                          ),
                                        ],
                                      ),
                                    ),
                                    state.data![0].latitude!.isNotEmpty && state.data![0].longitude!.isNotEmpty
                                        ? Container(
                                      child: GestureDetector(
                                        onTap: () =>
                                            BlocProvider.of<NavigatorBloc>(context)
                                                .add(NavigateToDetailMap(
                                                context,
                                                ModelDetailMap(
                                                    "Lokasi Aktivitas",
                                                    double.parse(state.data![0].latitude!),
                                                    double.parse(state.data![0].longitude!)))),
                                        child: Icon(
                                          Icons.pin_drop,
                                          size: 30,
                                          color: Colors.redAccent,
                                        ),
                                      ),
                                    )
                                        : Container()
                                  ],
                                ),
                              ),
                            )
                          ],
                        ),
                      )
                          : Container()
                    ],
                  ),
                ),
                Positioned(
                  bottom: 0,
                  child: state.data![0].button!.buttonApprove!
                      ? Container(
                    padding: EdgeInsets.only(left: 22, right: 22),
                    decoration: BoxDecoration(
                        boxShadow: [
                          BoxShadow(
                            color: Colors.grey.withOpacity(0.4),
                            spreadRadius: 2,
                            blurRadius: 7,
                            offset: Offset(
                                0, 1), // changes position of shadow
                          ),
                        ],
                        color: Colors.white,
                        borderRadius: new BorderRadius.only(
                            topLeft: Radius.circular(CustomStyle.boxRadius + 4),
                            topRight: Radius.circular(CustomStyle.boxRadius + 4))),
                    height: 62,
                    width: MediaQuery.of(context).size.width,
                    child: Row(
                      children: <Widget>[
                        Expanded(
                          child: TemplateButton(
                            onClick: () =>
                                TemplateConfirmationDialog(
                                    marginHeight: 13,
                                    'Apakah anda yakin akan menolak aktivitas sales ini?',
                                        () {
                                      BlocProvider.of<DataDailyAktivitasSalesBloc>(context)
                                          .add(TolakActivitySalesEvent(
                                          context,
                                          widget.data[1], state.data![0], 'detailActivity'));

                                      refresh = true;
                                    },
                                    context),
                            label: "Tolak",
                            color: Colors.grey[500],
                            heightButton: 28,
                            radius: CustomStyle.boxRadius + 4,
                            icon: Icons.close,
                            bold: true,
                            fontSize: CustomStyle.fontSizeSmall - 1,
                            iconSize: 16,
                            paddingTopBottom: 0,
                          ),
                        ),
                        SizedBox(
                          width: 12,
                        ),
                        Expanded(
                          child: TemplateButton(
                            onClick: () {
                              TemplateConfirmationDialog(
                                  marginHeight: 13,
                                  'Apakah anda yakin akan menyetujui aktivitas sales ini?',
                                      () {
                                    BlocProvider.of<DataDailyAktivitasSalesBloc>(context)
                                        .add(SetujuiActivitySalesEvent(
                                        context,
                                        widget.data[1], state.data![0], 'detailActivity'));

                                    refresh = true;
                                  },
                                  context);
                            },
                            label: "Setujui",
                            color: CustomStyle.color1,
                            heightButton: 28,
                            radius: CustomStyle.boxRadius + 4,
                            icon: Icons.check,
                            bold: true,
                            fontSize: CustomStyle.fontSizeSmall - 1,
                            iconSize: 16,
                            paddingTopBottom: 0,
                          ),
                        ),
                      ],
                    ),
                  )
                      : Container(),
                )
              ],
            )
              : state is DetailDailyAktivitasSalesEmptyState
                ? Center(child: Image.asset(ValueImage.noData, height: 250))
                : Center(child: CircularProgressIndicator(strokeWidth: 8))
          );
        }
      )

      // Scaffold(
      //   appBar: AppBar(
      //     centerTitle: true,
      //     flexibleSpace: Image(
      //       image: AssetImage(ValueImage.headerBiruDashboard),
      //       fit: BoxFit.cover,
      //     ),
      //     backgroundColor: Colors.transparent,
      //     title: Text(
      //       'Detail Activity',
      //       style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
      //     ),
      //   ),
      //   body: BlocBuilder<DetailDailyAktivitasSalesBloc, DetailDailyAktivitasSalesState>(
      //     builder: (context, state) {
      //       if(state is getListDetailDailyAktivitasSalesSuccessState){
      //         return Stack(
      //           children: [
      //             Container(
      //               height: double.infinity,
      //               color: Colors.white,
      //               margin: EdgeInsets.only(bottom: state.data![0].button!.buttonApprove! ? 60 : 0),
      //               padding: const EdgeInsets.all(22),
      //               child: Column(
      //                 crossAxisAlignment: CrossAxisAlignment.start,
      //                 children: [
      //                   Row(
      //                     mainAxisAlignment: MainAxisAlignment.spaceBetween,
      //                     children: [
      //                       Row(
      //                         children: [
      //                           Icon(
      //                             Icons.calendar_month,
      //                             size: 28,
      //                           ),
      //                           SizedBox(
      //                             width: 8,
      //                           ),
      //                           TemplateColumn(
      //                             title: "Tanggal Pengajuan",
      //                             value: state.data![0].waktu,
      //                           ),
      //                         ],
      //                       ),
      //                       TemplateButton(
      //                         label: state.data![0].status!.status,
      //                         color: Color(int.parse(state.data![0].status!.color!)),
      //                         contentColor: Color(int.parse(state.data![0].status!.fontColor!)),
      //                         fontSize: 14,
      //                         radius: 2,
      //                         paddingTopBottom: 4,
      //                         heightButton: 30,
      //                         bold: true,
      //                         paddingLeftRight: 16,
      //                       ),
      //                     ],
      //                   ),
      //                   SizedBox(
      //                     height: 16,
      //                   ),
      //                   Divider(),
      //                   widget.data[2]?Column(
      //                     children: [
      //                       TemplateColumn(
      //                         title: "Sales",
      //                         value: state.data![0].userInput,
      //                       ),
      //                       SizedBox(
      //                         height: 16,
      //                       ),
      //                     ],
      //                   ):Container(),
      //                   TemplateColumn(
      //                     title: "Aktivitas",
      //                     value: state.data![0].aktivitas,
      //                   ),
      //                   SizedBox(
      //                     height: 16,
      //                   ),
      //                   TemplateColumn(
      //                     title: "Pelanggan",
      //                     value: state.data![0].namaPelanggan,
      //                   ),
      //                   SizedBox(
      //                     height: 16,
      //                   ),
      //                   TemplateColumn(
      //                     title: "Jam",
      //                     value: state.data![0].jam!.substring(0,5),
      //                   ),
      //                   SizedBox(
      //                     height: 16,
      //                   ),
      //                   TemplateColumn(
      //                     title: "Keterangan",
      //                     value: state.data![0].ketMove=="" ? state.data![0].keterangan : state.data![0].ketMove,
      //                   ),
      //                   SizedBox(
      //                     height: 16,
      //                   ),
      //                   TemplateColumn(
      //                     title: "Poin",
      //                     value: state.data![0].point,
      //                   ),
      //                   SizedBox(
      //                     height: 16,
      //                   ),
      //                   state.data![0].flagUploadFoto == "1" && state.data![0].flagLokasi == "0"
      //                     ? Column(
      //                         crossAxisAlignment: CrossAxisAlignment.start,
      //                         children: [
      //                           Text("Lampiran",
      //                             style: TextStyle(
      //                                 fontSize: 12,
      //                                 fontWeight: FontWeight.w400,
      //                                 color: CustomStyle.fontColorGrey),
      //                           ),
      //                       SizedBox(
      //                         height: 8,
      //                       ),
      //                       state.data![0].pathFoto != null && state.data![0].pathFoto != "-"
      //                           ? Wrap(
      //                               spacing: 8,
      //                               runSpacing: 4,
      //                               children: [
      //                                 GestureDetector(
      //                                     onTap: () => BlocProvider.of<NavigatorBloc>(context)
      //                                         .add(NavigateToDetailImageClicked(context, state.data![0].pathFoto!)),
      //                                     child: Image.network(state.data![0].pathFoto!,
      //                                         width: MediaQuery.of(context).size.width / 4))
      //                               ]
      //                             )
      //                           : Container(
      //                               width: MediaQuery.of(context).size.width,
      //                               child: Column(
      //                                 crossAxisAlignment:
      //                                 CrossAxisAlignment.center,
      //                                 children: [
      //                                   Icon(Icons.image_not_supported,
      //                                     color: Colors.grey[500],
      //                                     size: MediaQuery.of(context).size.width / 3.2,),
      //                                   SizedBox(height: 14),
      //                                   Text("Tidak Ada Lampiran",
      //                                       style: TextStyle(
      //                                           color: CustomStyle.fontColorGrey,
      //                                           fontSize: CustomStyle.fontSizeSmall,
      //                                           fontWeight: FontWeight.w400))
      //                                 ],
      //                               ))
      //                     ],
      //                   )
      //                     : state.data![0].flagLokasi == "1"
      //                         ? Container(
      //                             decoration: BoxDecoration(
      //                                 borderRadius: BorderRadius.circular(13),
      //                                 border: Border.all()
      //                             ),
      //                             child: Row(
      //                               children: [
      //                                 Container(
      //                                   width: 90,
      //                                   height: 100,
      //                                   decoration: BoxDecoration(
      //                                     color: Colors.grey.shade100,
      //                                     borderRadius: BorderRadius.only(
      //                                         bottomLeft: Radius.circular(13),
      //                                         topLeft: Radius.circular(13)
      //                                     ),
      //                                   ),
      //                                   child: state.data![0].flagUploadFoto == "1"
      //                                       ? ClipRRect(
      //                                           borderRadius: BorderRadius.only(
      //                                               bottomLeft: Radius.circular(13),
      //                                               topLeft: Radius.circular(13)
      //                                           ),
      //                                           child: GestureDetector(
      //                                             onTap: ()=> BlocProvider.of<NavigatorBloc>(context)
      //                                             .add(NavigateToDetailImageClicked(context, state.data![0].pathFoto!)),
      //                                                 // .add(NavigateToDetailImageClicked(context, urlFoto)),
      //                                             child: Image.network(state.data![0].pathFoto!,
      //                                                 fit: BoxFit.cover,
      //                                                 errorBuilder: (con, obj, st){
      //                                                   return Icon(
      //                                                     Icons.image_not_supported,
      //                                                     size: 75,
      //                                                     color: Colors.grey,
      //                                                   );
      //                                                 }),
      //                                           ),
      //                                         )
      //                                       : Icon(
      //                                           Icons.image_not_supported,
      //                                           size: 75,
      //                                           color: Colors.grey,
      //                                         ),
      //                                 ),
      //                                 Expanded(
      //                                   child: Container(
      //                                     margin: EdgeInsets.only(left: 13, right: 13),
      //                                     child: Row(
      //                                       mainAxisAlignment: MainAxisAlignment.spaceBetween,
      //                                       children: [
      //                                         Expanded(
      //                                           child: Column(
      //                                             crossAxisAlignment: CrossAxisAlignment.start,
      //                                             children: [
      //                                               Text("Lokasi", style: TextStyle(fontWeight: FontWeight.w400, fontSize: 13)),
      //                                               SizedBox(height: 5),
      //                                               Wrap(
      //                                                 children: [
      //                                                   Text(state.data![0].latitude!, style: TextStyle(fontWeight: FontWeight.w700, fontSize: 13)),
      //                                                   SizedBox(width: 3),
      //                                                   Text(",", style: TextStyle(fontWeight: FontWeight.w700, fontSize: 13)),
      //                                                   SizedBox(width: 3),
      //                                                   Text(state.data![0].longitude!, style: TextStyle(fontWeight: FontWeight.w700, fontSize: 13)),
      //                                                   SizedBox(width: 3),
      //                                                 ],
      //                                               ),
      //                                             ],
      //                                           ),
      //                                         ),
      //                                         state.data![0].latitude!.isNotEmpty && state.data![0].longitude!.isNotEmpty
      //                                             ? Container(
      //                                           child: GestureDetector(
      //                                             onTap: () =>
      //                                                 BlocProvider.of<NavigatorBloc>(context)
      //                                                     .add(NavigateToDetailMap(
      //                                                     context,
      //                                                     ModelDetailMap(
      //                                                         "Lokasi Aktivitas",
      //                                                         double.parse(state.data![0].latitude!),
      //                                                         double.parse(state.data![0].longitude!)))),
      //                                             child: Icon(
      //                                               Icons.pin_drop,
      //                                               size: 30,
      //                                               color: Colors.redAccent,
      //                                             ),
      //                                           ),
      //                                         )
      //                                             : Container()
      //                                       ],
      //                                     ),
      //                                   ),
      //                                 )
      //                               ],
      //                             ),
      //                           )
      //                         : Container()
      //                 ],
      //               ),
      //             ),
      //             Positioned(
      //               bottom: 0,
      //               child: state.data![0].button!.buttonApprove!
      //                       ? Container(
      //                           padding: EdgeInsets.only(left: 22, right: 22),
      //                           decoration: BoxDecoration(
      //                             boxShadow: [
      //                               BoxShadow(
      //                                 color: Colors.grey.withOpacity(0.4),
      //                                 spreadRadius: 2,
      //                                 blurRadius: 7,
      //                                 offset: Offset(
      //                                     0, 1), // changes position of shadow
      //                               ),
      //                             ],
      //                             color: Colors.white,
      //                             borderRadius: new BorderRadius.only(
      //                                 topLeft: Radius.circular(CustomStyle.boxRadius + 4),
      //                                 topRight: Radius.circular(CustomStyle.boxRadius + 4))),
      //                             height: 62,
      //                             width: MediaQuery.of(context).size.width,
      //                             child: Row(
      //                               children: <Widget>[
      //                                 Expanded(
      //                                   child: TemplateButton(
      //                                     onClick: () =>
      //                                         TemplateConfirmationDialog(
      //                                           marginHeight: 13,
      //                                           'Apakah anda yakin akan menolak aktivitas sales ini?',
      //                                           () {
      //                                             BlocProvider.of<DataDailyAktivitasSalesBloc>(context)
      //                                                 .add(TolakActivitySalesEvent(
      //                                                 context,
      //                                                 widget.data[1], state.data![0], 'detailActivity'));
      //
      //                                             refresh = true;
      //                                           },
      //                                         context),
      //                                     label: "Tolak",
      //                                     color: Colors.grey[500],
      //                                     heightButton: 28,
      //                                     radius: CustomStyle.boxRadius + 4,
      //                                     icon: Icons.close,
      //                                     bold: true,
      //                                     fontSize: CustomStyle.fontSizeSmall - 1,
      //                                     iconSize: 16,
      //                                     paddingTopBottom: 0,
      //                                   ),
      //                                 ),
      //                                 SizedBox(
      //                                   width: 12,
      //                                 ),
      //                                 Expanded(
      //                                   child: TemplateButton(
      //                                     onClick: () {
      //                                       TemplateConfirmationDialog(
      //                                           marginHeight: 13,
      //                                           'Apakah anda yakin akan menyetujui aktivitas sales ini?',
      //                                               () {
      //                                             BlocProvider.of<DataDailyAktivitasSalesBloc>(context)
      //                                                 .add(SetujuiActivitySalesEvent(
      //                                                 context,
      //                                                 widget.data[1], state.data![0], 'detailActivity'));
      //
      //                                             refresh = true;
      //                                           },
      //                                           context);
      //                                     },
      //                                     label: "Setujui",
      //                                     color: CustomStyle.color1,
      //                                     heightButton: 28,
      //                                     radius: CustomStyle.boxRadius + 4,
      //                                     icon: Icons.check,
      //                                     bold: true,
      //                                     fontSize: CustomStyle.fontSizeSmall - 1,
      //                                     iconSize: 16,
      //                                     paddingTopBottom: 0,
      //                                   ),
      //                                 ),
      //                                 SizedBox(
      //                                   width: 16,
      //                                 ),
      //                                 GestureDetector(
      //                                     onTap: () =>
      //                                         BlocProvider.of<NavigatorBloc>(context)
      //                                             .add(NavigatePop(context)),
      //                                     child: Icon(
      //                                       Icons.chevron_left,
      //                                       size: 34,
      //                                       color: CustomStyle.fontColorGrey,
      //                                     ))
      //                               ],
      //                             ),
      //                           )
      //                       : Container(),
      //             )
      //           ],
      //         );
      //       } else if(state is DetailDailyAktivitasSalesEmptyState){
      //         return Center(child: Image.asset(ValueImage.noData, height: 250));
      //       }
      //       else{
      //         return Center(child: CircularProgressIndicator(strokeWidth: 8));
      //       }
      //     }
      //   ),
      // ),
    );
  }
}
