import 'package:absenkuv3/Bloc/Reimbursement/RekapReimbursementSayaBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mReimbursementPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/UI/templateDateRangePicker.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'komponenReimbursement.dart';

class HalamanRekapReimbursementSaya extends StatefulWidget {
  @override
  _HalamanRekapReimbursementSayaState createState() => _HalamanRekapReimbursementSayaState();
}

class _HalamanRekapReimbursementSayaState extends State<HalamanRekapReimbursementSaya> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(InitialDate());
    BlocProvider.of<RekapReimbursementSayaBloc>(context).add(GetListReimbursementEvent(context, null));
    _scrollController.addListener(()=>BlocProvider.of<RekapReimbursementSayaBloc>(context).add(LoadMoreEvent(context, scaffoldKey, _scrollController)));
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageReimbursementModel>(
        future: PengaturanBahasa().reimbursement(),
        builder: (context, snapshot){
          if(snapshot.connectionState == ConnectionState.done){
            return Scaffold(
              key: scaffoldKey,
              body: Stack(
                children: [
                  BlocBuilder<RekapReimbursementSayaBloc, RekapReimbursementSayaState>(
                      builder: (BuildContext context, RekapReimbursementSayaState state){
                        if(state is GetListReimbursementSuccessState || state is LoadMoreProgressState)
                          return Stack(
                            children: <Widget>[
                              ListView.builder(
                                  physics: AlwaysScrollableScrollPhysics(),
                                  controller: _scrollController,
                                  itemCount: state.data!.length,
                                  itemBuilder: (BuildContext context, index) {
                                    return CardReimbursement(state.data![index], 'reimbursementSaya', snapshot.data!);
                                  }
                              ),
                              state is LoadMoreProgressState? Positioned(
                                  bottom :16,
                                  child: Container(
                                      width: MediaQuery.of(context).size.width,
                                      child: Center(child: CircularProgressIndicator(strokeWidth: 8,)))):Container(),
                            ],
                          );
                        else if(state is ReimbursementProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                        else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
                      }),
                  Positioned(
                    bottom: 16,
                    right: 14,
                    child: BlocListener<DateRangePickerBloc, DateRangePickerState>(
                      listener: (BuildContext context, DateRangePickerState dateRangePickerState){
                        if(dateRangePickerState is DateAvailable) BlocProvider.of<RekapReimbursementSayaBloc>(context).add(GetListReimbursementEvent(context, ModelFilter(dateRange: dateRangePickerState.date)));
                      },
                      child: TemplateDateRangePicker(),
                    ),
                  ),
                ],
              ),
            );
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
    );
  }
}
