import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/Patroli/CekValidasiWaktuBloc.dart';
import 'package:absenkuv3/Bloc/Patroli/JadwalPatroliBloc.dart';
import 'package:absenkuv3/Bloc/Patroli/QrBloc.dart';
import 'package:absenkuv3/Bloc/Patroli/SelectedJadwalPatroliBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mPatroliPage.dart';
import 'package:absenkuv3/Repository/Model/mChekpoint.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Patroli/CustomBottomSheet.dart';
import 'package:absenkuv3/UI/Modul/Patroli/HalamanListPatroliPegawai.dart';
import 'package:absenkuv3/UI/Modul/Patroli/WidgetQrPatroli.dart';
import 'package:absenkuv3/UI/Template/style.dart';
// import 'package:clean_dialog/clean_dialog.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'HalamanListPatroliSaya.dart';
import 'package:intl/intl.dart';

class ParentTabPatroli extends StatefulWidget {
  const ParentTabPatroli({Key? key}) : super(key: key);
  @override
  State<ParentTabPatroli> createState() => _ParentTabPatroli();
}

class _ParentTabPatroli extends State<ParentTabPatroli>
    with WidgetsBindingObserver {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  final GlobalKey<FormState> formKey = GlobalKey<FormState>();
  JadwalChekpoint? selectedJadwalChekpoint;
  int tabLength = 2;
  DateTime now = DateTime.now();
  DateTime utc = DateTime.now().toUtc();
  @override
  void initState() {
    WidgetsBinding.instance.addObserver(this);
    print("ini tanggal utc to mili " + utc.millisecondsSinceEpoch.toString());
    String formattedDate = DateFormat('H:m:s').format(now);
    print("ini format lokal " + formattedDate);

    BlocProvider.of<JadwalPatroliBloc>(context).add(getListJadwalPatroliEvent(
        context, utc.millisecondsSinceEpoch.toString(), formattedDate));
    super.initState();
  }

  @override
  void dispose() {
    WidgetsBinding.instance.removeObserver(this);
    super.dispose();
  }

  // void didChangeAppLifecycleState(AppLifecycleState state) async {
  //   if (state == AppLifecycleState.resumed) {
  //     String formattedDate = DateFormat('H:m:s').format(now);
  //     print("ini format lokal " + formattedDate);
  //     BlocProvider.of<CekValidasiWaktuBloc>(context)
  //         .add(ChekValidasiWaktu(utc.millisecondsSinceEpoch.toString()));
  //     BlocProvider.of<JadwalPatroliBloc>(context).add(getListJadwalPatroliEvent(
  //         context, utc.millisecondsSinceEpoch.toString(), formattedDate));
  //   }
  // }
  void didChangeAppLifecycleState(AppLifecycleState state) async {
    if (!mounted) return;

    if (state == AppLifecycleState.resumed) {
      String formattedDate = DateFormat('H:m:s').format(now);
      print("ini format lokal " + formattedDate);

      BlocProvider.of<CekValidasiWaktuBloc>(context)
          .add(ChekValidasiWaktu(utc.millisecondsSinceEpoch.toString()));

      BlocProvider.of<JadwalPatroliBloc>(context).add(getListJadwalPatroliEvent(
          context, utc.millisecondsSinceEpoch.toString(), formattedDate));
    }
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PagePatroliModel>(
      future: PengaturanBahasa().patroli(),
      builder: (BuildContext context, snapshot) {
        if (snapshot.connectionState == ConnectionState.done) {
          return BlocBuilder<AuthBloc, LoginRespon>(
              builder: (BuildContext context, LoginRespon loginRespon) {
            return DefaultTabController(
              length: tabLength,
              child: Scaffold(
                appBar: AppBar(
                  centerTitle: true,
                  flexibleSpace: Image(
                    image: AssetImage(ValueImage.headerBiruDashboard),
                    fit: BoxFit.cover,
                  ),
                  backgroundColor: Colors.transparent,
                  title: Text(
                    snapshot.data!.menuPatroli!.title!.parentTitle.toString(),
                    style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                  ),
                  bottom: loginRespon.dataLogin!.level != 3
                      ? TabBar(
                          labelPadding: EdgeInsets.all(0),
                          indicatorSize: TabBarIndicatorSize.tab,
                          indicatorWeight: 4,
                          isScrollable: true,
                          tabs: [
                            Container(
                              width:
                                  MediaQuery.of(context).size.width / tabLength,
                              child: Tab(
                                text: snapshot.data!.menuPatroli!.title!.tabSaya
                                    .toString(),
                              ),
                            ),
                            Container(
                              width:
                                  MediaQuery.of(context).size.width / tabLength,
                              child: Tab(
                                text: snapshot
                                    .data!.menuPatroli!.title!.tabKaryawan
                                    .toString(),
                              ),
                            ),
                          ],
                        )
                      : null,
                  actions: [
                    GestureDetector(
                      onTap: () {
                        showModalBottomSheet(
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.only(
                                topLeft: Radius.circular(30.0),
                                topRight: Radius.circular(30.0),
                              ),
                            ),
                            backgroundColor: Colors.white,
                            context: context,
                            builder: (BuildContext context) {
                              return MultiBlocProvider(
                                  providers: [
                                    BlocProvider<SelectedJadwalPatroliBloc>(
                                        create: (context) {
                                      return SelectedJadwalPatroliBloc();
                                    })
                                  ],
                                  child: CustomBottomSheet(
                                      snapshot.data!.menuPatroli));
                            });
                      },
                      child: Container(
                          margin: EdgeInsets.only(right: 14),
                          child: Icon(
                            Icons.add,
                            size: 26,
                          )),
                    ),
                  ],
                ),
                body: TabBarView(
                  physics: NeverScrollableScrollPhysics(),
                  children: [
                    HalamanListPatroliSaya(),
                    HalamanListPatroliPegawai()
                  ],
                ),
              ),
            );
          });
        } else {
          return Container();
        }
      },
    );
  }
}
