import 'package:absenkuv3/Bloc/Patroli/PatroliBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Patroli/KomponenPatroli.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/UI/templateDateRangePicker.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListPatroliSaya extends StatefulWidget {
  @override
  _HalamanListPatroliSayaState createState() => _HalamanListPatroliSayaState();
}

class _HalamanListPatroliSayaState extends State<HalamanListPatroliSaya> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  // late QRBloc qrBloc;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(SetDate([DateTime.now(),DateTime.now()]));
    BlocProvider.of<PatroliBloc>(context).add(getListPatroliEvent(context, null));
    _scrollController.addListener(()=>BlocProvider.of<PatroliBloc>(context).add(loadMoreEvent(context, scaffoldKey, _scrollController)));
    // qrBloc = QRBloc();
  }

  @override
  void dispose() {
    // qrBloc.close();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: Stack(
        children: [
          BlocBuilder<PatroliBloc, PatroliState>(
              builder: (BuildContext context, PatroliState state){
                if(state is getListPatroliSuccessState || state is LoadMoreProgressState)
                  return Stack(
                    children: <Widget>[
                      ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          controller: _scrollController,
                          itemCount: state.data!.length,
                          itemBuilder: (BuildContext context, index) {
                            return CardPatroli(state.data![index],scaffoldKey, 'checkpointSaya');
                          }
                      ),
                      state is LoadMoreProgressState? Positioned(
                          bottom :16,
                          child: Container(
                              width: MediaQuery.of(context).size.width,
                              child: Center(child: CircularProgressIndicator(strokeWidth: 8,)))):Container(),
                    ],
                  );
                else if(state is PatroliProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
              }),
          Positioned(
            bottom: 16,
            right: 14,
            child: BlocListener<DateRangePickerBloc, DateRangePickerState>(
              listener: (BuildContext context, DateRangePickerState dateRangePickerState){
                if(dateRangePickerState is DateAvailable) BlocProvider.of<PatroliBloc>(context).add(getListPatroliEvent(context, ModelFilter(dateRange: dateRangePickerState.date)));
              },
              child: TemplateDateRangePicker(),
            ),
          ),
        ],
      ),
    );
  }
}
