import 'package:absenkuv3/Repository/Model/PageModel/mLoginPage.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Login_SplashScreen/halamanLogin.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';

class HalamanLupaPasswordSuccess extends StatefulWidget {
  final PageLoginModel redaksional;
  HalamanLupaPasswordSuccess(this.redaksional);

  @override
  State<HalamanLupaPasswordSuccess> createState() =>
      _HalamanLupaPasswordSuccessState();
}

class _HalamanLupaPasswordSuccessState
    extends State<HalamanLupaPasswordSuccess> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  TextEditingController username = TextEditingController();
  Color col = Colors.grey;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        centerTitle: true,
        flexibleSpace: Image(
          image: AssetImage(ValueImage.headerBiruDashboard),
          fit: BoxFit.cover,
        ),
        backgroundColor: Colors.transparent,
        title: Text(
          widget.redaksional.menuLupaPasswordSuccess!.title!,
          style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
        ),
      ),
      body: Container(
        margin: EdgeInsets.fromLTRB(13, 0, 13, 13),
        // color: Colors.yellow,
        child: Stack(
          children: [
            Container(
              padding: EdgeInsets.only(bottom: 100),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Container(
                      width: MediaQuery.of(context).size.width,
                      child: Image.asset(ValueImage.iconCekLP, height: 150)),
                  SizedBox(height: 17),
                  Text(widget.redaksional.menuLupaPasswordSuccess!.header!,
                      style:
                          TextStyle(fontWeight: FontWeight.w700, fontSize: 18)),
                  SizedBox(height: 3),
                  Container(
                      margin: EdgeInsets.only(left: 95, right: 95),
                      child: Text(
                          widget.redaksional.menuLupaPasswordSuccess!.subHeader!,
                          style: TextStyle(fontSize: 13, color: Colors.grey),
                          textAlign: TextAlign.center)),
                  SizedBox(height: 43),
                ],
              ),
            ),
            Positioned(
              bottom: 7,
              child: Container(
                // color: Colors.red,
                width: MediaQuery.of(context).size.width - 26,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.end,
                  children: [
                    // Row(
                    //   mainAxisAlignment: MainAxisAlignment.center,
                    //   children: [
                    //     Text('Ingat password Anda?  ', style: TextStyle(color: Colors.grey, fontSize: 13, fontWeight: FontWeight.w500)),
                    //     GestureDetector(
                    //         onTap: ()=> Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => HalamanLogin())),
                    //         child: Text('Login', style: TextStyle(color: CustomStyle.color1, fontSize: 13, fontWeight: FontWeight.w500))),
                    //   ],
                    // ),
                    // SizedBox(height: 41),
                    TemplateButton(
                      onClick: () async {
                        Navigator.pushReplacement(context,
                            MaterialPageRoute(builder: (_) => HalamanLogin()));
                      },
                      label: "Login",
                      color: CustomStyle.color1,
                      fontSize: CustomStyle.fontSizeNormal,
                      paddingTopBottom: 8,
                      expand: true,
                      borderColor: Colors.white,
                      radius: 24,
                      heightButton: 42,
                    ),
                  ],
                ),
              ),
            )
          ],
        ),
      ),
    );
  }

  openDialog(bool peringatan, String title, String deskripsi) {
    return showDialog(
        context: context,
        barrierDismissible: false,
        builder: (c) {
          return AlertDialog(
            title: Stack(
              children: [
                Container(
                  margin: EdgeInsets.only(top: 37),
                  child: Center(
                      child: peringatan
                          ? Icon(
                              Icons.info_outline,
                              size: 75,
                              color: Colors.orange,
                            )
                          : Image.asset(ValueImage.iconErrorLP, height: 65)),
                ),
                Align(
                    alignment: Alignment.topRight,
                    child: GestureDetector(
                        onTap: () => Navigator.pop(context),
                        child: Icon(
                          Icons.clear,
                          size: 23,
                        )))
              ],
            ),
            titlePadding: EdgeInsets.all(0),
            contentPadding:
                EdgeInsets.only(top: 5, left: 27, right: 27, bottom: 37),
            content: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              mainAxisSize: MainAxisSize.min,
              children: [
                Text(title,
                    style:
                        TextStyle(fontWeight: FontWeight.w700, fontSize: 17)),
                SizedBox(height: peringatan ? 9 : 3),
                Text(deskripsi,
                    style: TextStyle(color: Colors.grey, fontSize: 13),
                    textAlign: TextAlign.center),
              ],
            ),
          );
        });
  }
}
