import 'package:absenkuv3/Bloc/FilterBottomSheetBloc.dart';
import 'package:absenkuv3/Bloc/Lembur/RekapLemburPegawaiBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mLemburPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Lembur/KomponenLembur.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/FilterBottomSheet.dart';
import 'package:absenkuv3/UI/Template/FilterHeaderSheet.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListRekapLemburPegawai extends StatefulWidget {
  final PageLemburModel redaksional;
  HalamanListRekapLemburPegawai(this.redaksional);

  @override
  _HalamanListRekapLemburPegawaiState createState() =>
      _HalamanListRekapLemburPegawaiState();
}

class _HalamanListRekapLemburPegawaiState
    extends State<HalamanListRekapLemburPegawai> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  ModelFilter? modelFilter;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(InitialDate());
    BlocProvider.of<RekapLemburPegawaiBloc>(context)
        .add(getListLemburEvent(context, null));
    _scrollController.addListener(() =>
        BlocProvider.of<RekapLemburPegawaiBloc>(context)
            .add(loadMoreEvent(context, scaffoldKey, _scrollController)));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: Stack(
        children: [
          Column(
            children: [
              Container(
                height: 50,
                width: MediaQuery.of(context).size.width * 1.5,
                child:
                    BlocListener<FilterBottomSheetBloc, FilterBottomSheetState>(
                        listener: (BuildContext context,
                            FilterBottomSheetState state) {
                          if (state is setFilterSuccess) {
                            modelFilter = state.modelFilter;
                            BlocProvider.of<RekapLemburPegawaiBloc>(context)
                                .add(getListLemburEvent(context, modelFilter));
                          }
                        },
                        child: FilterHeaderSheet()),
              ),
            ],
          ),
          Padding(
            padding: const EdgeInsets.only(top: 50),
            child: BlocBuilder<RekapLemburPegawaiBloc, RekapLemburPegawaiState>(
                builder: (BuildContext context, RekapLemburPegawaiState state) {
              if (state is getListLemburSuccessState ||
                  state is LoadMoreProgressState)
                return Stack(
                  children: <Widget>[
                    ListView.builder(
                        physics: AlwaysScrollableScrollPhysics(),
                        controller: _scrollController,
                        itemCount: state.data!.length,
                        itemBuilder: (BuildContext context, index) {
                          return CardLembur(state.data![index], 'rekapPegawai',
                              scaffoldKey, widget.redaksional);
                        }),
                    state is LoadMoreProgressState
                        ? Positioned(
                            bottom: 16,
                            child: Container(
                                width: MediaQuery.of(context).size.width,
                                child: Center(
                                    child: CircularProgressIndicator(
                                  strokeWidth: 8,
                                ))))
                        : Container(),
                  ],
                );
              else if (state is LemburProgressState)
                return Center(
                  child: CircularProgressIndicator(
                    strokeWidth: 8,
                  ),
                );
              else
                return Center(
                  child: Image.asset(
                    ValueImage.noData,
                    height: 250,
                  ),
                );
            }),
          ),
        ],
      ),
    );
  }
}
