// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables

import 'package:absenkuv3/Bloc/Kpi/KpiTeam/GetListKpiTeamBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/Core/mFilterKpi.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiTeam/komponen/KomponenKpiTeam.dart';
import 'package:absenkuv3/UI/Template/CupertinoPicker/Bloc/date_pick_bloc.dart';
import 'package:absenkuv3/UI/Template/CupertinoPicker/UI/TemplateMonthYearPicker.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanKpiTeam extends StatefulWidget {
  const HalamanKpiTeam({Key? key}) : super(key: key);

  @override
  State<HalamanKpiTeam> createState() => _HalamanKpiTeamState();
}

class _HalamanKpiTeamState extends State<HalamanKpiTeam> {
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    BlocProvider.of<DatePickBloc>(context)
        .add(PickStartDateEvent(DateTime.now()));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Stack(
      children: [
        BlocBuilder<GetListkpiTeamBloc, DataListKpiTeamState>(
            builder: (BuildContext context, DataListKpiTeamState state) {
          if (state is GetListKpiTeamSuccessState)
            return Stack(
              children: <Widget>[
                ListView.builder(
                    physics: AlwaysScrollableScrollPhysics(),
                    controller: _scrollController,
                    itemCount: state.data!.length,
                    itemBuilder: (BuildContext context, index) {
                      return CardListKpiTeam(state.data![index], 'pengajuan');
                    }),
              ],
            );
          else if (state is DataListKpiTeamProgressState)
            return Center(
              child: CircularProgressIndicator(
                strokeWidth: 8,
              ),
            );
          else
            return Center(
              child: Image.asset(
                ValueImage.noData,
                height: 250,
              ),
            );
        }),
        Positioned(
          bottom: 16,
          right: 14,
          child: BlocListener<DatePickBloc, DatePickState>(
              listener: (BuildContext context, DatePickState state) {
                if (state is DateSelected) {
                  BlocProvider.of<GetListkpiTeamBloc>(context).add(
                      GetDataListKpiTeam(
                          ModelFilterKpi(status: '6,1,4,7,8,9',monthYear: state.startDate)));
                }
              },
              child: TemplateMonthYearPicker()),
        ),
      ],
    );
  }
}
