import 'package:absenkuv3/Bloc/Kpi/KpiTeam/GetListKpiBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/Core/mFilterKpi.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiTeam/komponen/KomponenKpiTeam.dart';
import 'package:absenkuv3/UI/Template/CupertinoPicker/Bloc/date_pick_bloc.dart';
import 'package:absenkuv3/UI/Template/CupertinoPicker/UI/TemplateMonthYearPicker.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanKpiDraftTeam extends StatefulWidget {
  const HalamanKpiDraftTeam({Key? key}) : super(key: key);

  @override
  State<HalamanKpiDraftTeam> createState() => _HalamanKpiDraftTeamState();
}

class _HalamanKpiDraftTeamState extends State<HalamanKpiDraftTeam> {
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    BlocProvider.of<DatePickBloc>(context)
        .add(PickStartDateEvent(DateTime.now()));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Stack(
      children: [
        BlocBuilder<GetListKpiBloc, DataListKpiState>(
            builder: (BuildContext context, DataListKpiState state) {
          if (state is GetListKpiSuccessState)
            return Stack(
              children: <Widget>[
                ListView.builder(
                    physics: AlwaysScrollableScrollPhysics(),
                    controller: _scrollController,
                    itemCount: state.data!.length,
                    itemBuilder: (BuildContext context, index) {
                      return CardListKpi(state.data![index], '');
                    }),
              ],
            );
          else if (state is DataListKpiProgressState)
            return Center(
              child: CircularProgressIndicator(
                strokeWidth: 8,
              ),
            );
          else
            return Center(
              child: Image.asset(
                ValueImage.noData,
                height: 250,
              ),
            );
        }),
        Positioned(
          bottom: 16,
          right: 14,
          child: BlocListener<DatePickBloc, DatePickState>(
              listener: (BuildContext context, DatePickState state) {
                if (state is DateSelected) {
                  BlocProvider.of<GetListKpiBloc>(context).add(GetDataListKpi(
                      ModelFilterKpi(monthYear: state.startDate)));
                }
              },
              child: TemplateMonthYearPicker()),
        ),
      ],
    );
  }
}
