import 'package:absenkuv3/Bloc/Kpi/KpiSaya/GetDataPengajuanKpiSayaBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiSaya/HalamanDetailPengajuanKpiSaya/komponen/KomponenDetailPengajuanSaya.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanDetailPengajuanKpiSaya extends StatefulWidget {
  var data;

  HalamanDetailPengajuanKpiSaya(this.data);

  @override
  State<HalamanDetailPengajuanKpiSaya> createState() =>
      _HalamanDetailPengajuanKpiSayaState();
}

class _HalamanDetailPengajuanKpiSayaState
    extends State<HalamanDetailPengajuanKpiSaya> {
  @override
  void initState() {
    BlocProvider.of<GetDataPengajuanKpiSayaBloc>(context).add(
        GetDataPegajuanKpiSaya(context, widget.data![0], widget.data![1],
            widget.data![2], widget.data![3]));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          flexibleSpace: Image(
            image: AssetImage(ValueImage.headerBiruDashboard),
            fit: BoxFit.cover,
          ),
          backgroundColor: Colors.transparent,
          centerTitle: true,
          title: Text(
            'Actual KPI',
            style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
          ),
        ),
        body: BlocBuilder<GetDataPengajuanKpiSayaBloc,
                GetDataPengajuanKpiSayaState>(
            builder: (BuildContext ctk, GetDataPengajuanKpiSayaState state) {
          if (state is GetDataPengajuanKpiSayaSuccessState) {
            return KomponenDetailPengajuanSaya(
                state.data!,
                ParsingModelKaryawan(
                  id_karyawan: widget.data[0],
                  id_company: widget.data[1],
                  bulan: widget.data[2],
                  tahun: widget.data[3],
                  karyawan: widget.data[4],
                ));
          } else if (state is DataPengajuanKpiSayaProgressState)
            return Center(
              child: CircularProgressIndicator(
                strokeWidth: 8,
              ),
            );
          else
            return Center(
              child: Image.asset(
                ValueImage.noData,
                height: 250,
              ),
            );
        }));
  }
}
