import 'package:absenkuv3/Bloc/Kpi/KpiApproval/GetDataPengajuanAspekKepribadianBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiFinal/FinalAspekKepribadian/komponen/KomponenFinalAspekKepribadian.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class FinalAspekKepribadian extends StatefulWidget {
  var data;
  FinalAspekKepribadian(this.data);

  @override
  State<FinalAspekKepribadian> createState() => _FinalAspekKepribadianState();
}

class _FinalAspekKepribadianState extends State<FinalAspekKepribadian> {
  @override
  void initState() {
    BlocProvider.of<GetDataPengajuanAspekKepribadianBloc>(context).add(
        GetDataAspekKepribadian(
            context,
            ParsingModelKaryawan(
                id_karyawan: widget.data[0],
                id_company: widget.data[1],
                bulan: widget.data[2],
                tahun: widget.data[3])));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(body: BlocBuilder<GetDataPengajuanAspekKepribadianBloc,
            GetDataPengajuanAspekKepribadianState>(
        builder:
            (BuildContext ctk, GetDataPengajuanAspekKepribadianState state) {
      if (state is GetDataPengajuanAspekKepribadianSuccessState) {
        return KomponenFinalAspekKepribadian(
            state.data!,
            ParsingModelKaryawan(
                id_karyawan: widget.data[0],
                id_company: widget.data[1],
                bulan: widget.data[2],
                tahun: widget.data[3]));
      } else if (state is DataPengajuanAspekKepribadianProgressState)
        return Center(
          child: CircularProgressIndicator(
            strokeWidth: 8,
          ),
        );
      else
        return Center(
          child: Image.asset(
            ValueImage.noData,
            height: 250,
          ),
        );
    }));
  }
}
