import 'package:absenkuv3/Bloc/Kpi/KpiApproval/GetDataPengajuanAspekKedisiplinanBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiApprovalTeam/HalamanPengajuanApprovalKpiTeam/PengajuanAspekKedisiplinan/Komponen/KomponenPengajuanAspekKedisiplinan.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class FinalAspekKedisiplinan extends StatefulWidget {
  var data;
  FinalAspekKedisiplinan(this.data);

  @override
  State<FinalAspekKedisiplinan> createState() => _FinalAspekKedisiplinanState();
}

class _FinalAspekKedisiplinanState extends State<FinalAspekKedisiplinan> {
  @override
  void initState() {
    BlocProvider.of<GetDataPengajuanAspekKedisiplinanBloc>(context).add(
        GetDataAspekKedisiplinan(
            context,
            ParsingModelKaryawan(
                id_karyawan: widget.data[0],
                id_company: widget.data[1],
                bulan: widget.data[2],
                tahun: widget.data[3])));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(body: BlocBuilder<GetDataPengajuanAspekKedisiplinanBloc,
            GetDataPengajuanAspekKedisiplinanState>(
        builder:
            (BuildContext ctk, GetDataPengajuanAspekKedisiplinanState state) {
      if (state is GetDataPengajuanAspekKepribadianSuccessState) {
        return Column(
          children: [
            DataTabelPengajuanAspekKedisiplinan(
              data: state.data,
            ),
            Container(
              decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  border: Border.all(color: Colors.orange),
                  color: Color(0xffFFF8DB)),
              width: MediaQuery.of(context).size.width,
              // padding: EdgeInsets.all(10),
              margin: EdgeInsets.all(10),
              child: Row(
                children: [
                  SizedBox(width: 5),
                  Icon(
                    Icons.info_outline,
                    color: Colors.orange,
                  ),
                  SizedBox(width: 5),
                  Container(
                    width: 1,
                    height: 80,
                    color: Colors.grey.withOpacity(0.5),
                  ),
                  SizedBox(width: 8), // Spasi antara garis dan teks
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text("Terlambat satuan menit"),
                      SizedBox(
                        height: 2,
                      ),
                      Text("Pulang cepat satuan menit"),
                      SizedBox(
                        height: 2,
                      ),
                      Text("Tidak absen pulang satuan hari"),
                      SizedBox(
                        height: 2,
                      ),
                      Text("Alpa satuan hari"),
                      SizedBox(
                        height: 2,
                      ),
                    ],
                  ),
                ],
              ),
            )
          ],
        );
      } else if (state is DataPengajuanAspekKedisiplinanProgressState)
        return Center(
          child: CircularProgressIndicator(
            strokeWidth: 8,
          ),
        );
      else
        return Center(
          child: Image.asset(
            ValueImage.noData,
            height: 250,
          ),
        );
    }));
  }
}
