import 'package:absenkuv3/Bloc/CustomBloc.dart';
import 'package:absenkuv3/Bloc/Kpi/KpiApproval/GetDataPengajuanAspekKepribadianBloc.dart';
import 'package:absenkuv3/Bloc/Kpi/KpiApproval/GetDataPengajuanNilaiIndividuBloc.dart';
import 'package:absenkuv3/Bloc/Kpi/KpiApproval/SetujuiApprovalkpiBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiApprovalTeam/HalamanPengajuanApprovalKpiTeam/PengajuanNilaiIndividu/komponen/KomponenPengajuanNilaiIndividu.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanPengajuanNilaiIndividu extends StatefulWidget {
  var data;
  HalamanPengajuanNilaiIndividu(this.data);

  @override
  State<HalamanPengajuanNilaiIndividu> createState() =>
      _HalamanPengajuanNilaiIndividuState();
}

class _HalamanPengajuanNilaiIndividuState
    extends State<HalamanPengajuanNilaiIndividu> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();

  final TextEditingController _roleController = TextEditingController();
  final TextEditingController _carrerController = TextEditingController();

  @override
  void initState() {
    BlocProvider.of<GetDataPengajuanNilaiIndividuBloc>(context).add(
        GetDataPengajuanNilaiIndividu(
            context,
            ParsingModelKaryawan(
                id_karyawan: widget.data[0],
                id_company: widget.data[1],
                bulan: widget.data[2],
                tahun: widget.data[3])));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: Column(
        children: [
          Expanded(
            child: BlocBuilder<GetDataPengajuanNilaiIndividuBloc,
                GetDataPengajuanNilaiIndividuState>(
              builder: (BuildContext context,
                  GetDataPengajuanNilaiIndividuState state) {
                if (state is GetDataPengajuanNilaiIndividuSuccessState) {
                  return Column(
                    children: [
                      Expanded(
                        child: SingleChildScrollView(
                          child: Column(
                            children: [
                              state.data!.informasiKomponen?.ketPeriode != null
                                  ? KomponenPeriode(
                                      state.data!.informasiKomponen!)
                                  : Container(),
                              KomponenTabelNilai(state.data!.informasiSkor!),
                              KomponenGrade(
                                data: state.data!.informasiGrade!,
                              ),
                              KomponenInformasi(state.data!.informasiKomponen)
                            ],
                          ),
                        ),
                      ),
                      state.data!.informasiKomponen?.ignorePointer == true
                          ? Container()
                          : Container(
                              width: MediaQuery.of(context).size.width,
                              margin: EdgeInsets.all(5),
                              child: ElevatedButton(
                                style: ElevatedButton.styleFrom(
                                  backgroundColor: Colors.green,
                                  foregroundColor: Colors.white,
                                  shape: RoundedRectangleBorder(
                                    borderRadius: BorderRadius.circular(20),
                                  ),
                                ),
                                onPressed:
                                    state.data!.informasiKomponen?.button ==
                                            false
                                        ? null
                                        : () {
                                            _showDialog();
                                          },
                                child: const Text("Setujui"),
                              ),
                            ),
                    ],
                  );
                } else if (state is DataPengajuanNilaiIndividuProgressState) {
                  return Center(
                    child: CircularProgressIndicator(
                      strokeWidth: 8,
                    ),
                  );
                } else {
                  return Center(
                    child: Image.asset(
                      ValueImage.noData,
                      height: 250,
                    ),
                  );
                }
              },
            ),
          ),
        ],
      ),
    );
  }

  void _showDialog() {
    showDialog(
        context: context,
        builder: (BuildContext context) {
          return AlertDialog(
            contentPadding: EdgeInsets.zero,
            shape: RoundedRectangleBorder(
              borderRadius: BorderRadius.only(
                  topLeft: Radius.circular(10),
                  topRight: Radius.circular(10),
                  bottomLeft: Radius.circular(10),
                  bottomRight: Radius.circular(10)),
            ),
            content: Column(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Container(
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.only(
                        topLeft: Radius.circular(10),
                        topRight: Radius.circular(10)),
                    color: CustomStyle.color1,
                  ),
                  height: 60,
                  width: MediaQuery.of(context).size.width,
                  child: Center(
                    child: Text("Kebutuhan Pengembangan",
                        style: TextStyle(
                            color: Colors.white, fontWeight: FontWeight.bold)),
                  ),
                ),
                Container(
                  margin: EdgeInsets.only(left: 5,right: 5),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      SizedBox(
                        height: 10,
                      ),
                      Container(
                        margin: EdgeInsets.only(left: 10),
                        child: Text('Saran pengembangan untuk posisi saat ini'),
                      ),
                      Container(
                        margin:
                            EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                        child: TextFormField(
                          controller: _roleController,
                          maxLines: 5,
                          minLines: 4,
                          decoration: InputDecoration(
                            border: OutlineInputBorder(),
                          ),
                        ),
                      ),
                      SizedBox(
                        height: 10,
                      ),
                      Container(
                        margin: EdgeInsets.only(left: 10),
                        child: Text('Saran untuk pengembangan karir'),
                      ),
                      Container(
                        margin:
                            EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                        child: TextFormField(
                          controller: _carrerController,
                          maxLines: 5,
                          minLines: 4,
                          decoration: InputDecoration(
                            border: OutlineInputBorder(),
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
              ],
            ),
            actions: [
              Row(
                children: [
                  Expanded(
                    child: GestureDetector(
                      onTap: () {
                        Navigator.of(context).pop();
                      },
                      child: Container(
                        padding: EdgeInsets.all(14),
                        margin:
                            EdgeInsets.symmetric(horizontal: 5, vertical: 5),
                        decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(20),
                            border: Border.all(color: Colors.indigo)),
                        child: Center(
                            child: Text('Batal',
                                style: TextStyle(
                                    color: Colors.indigo,
                                    fontWeight: FontWeight.bold))),
                      ),
                    ),
                  ),
                  Expanded(
                    child: GestureDetector(
                      onTap: () {
                        String role = _roleController.text.trim();
                        String carrer = _carrerController.text.trim();
                        if (role.isEmpty) {
                          showSnackBarDelayed(
                              scaffoldKey,
                              'Saran pengembangan untuk posisi saat ini tidak boleh kosong',
                              context);
                        } else if (carrer.isEmpty) {
                          showSnackBarDelayed(
                              scaffoldKey,
                              'Saran untuk pengembangan karir tidak boleh kosong',
                              context);
                        } else {
                          BlocProvider.of<SetujuiApprovalKpiBloc>(context).add(
                              SetujuiApprovalKpi(
                                  ParsingModelKaryawan(
                                      id_karyawan: widget.data[0],
                                      id_company: widget.data[1],
                                      bulan: widget.data[2],
                                      tahun: widget.data[3]),
                                  role,
                                  carrer,
                                  context));
                        }
                      },
                      child: Container(
                        padding: EdgeInsets.all(14),
                        margin:
                            EdgeInsets.symmetric(horizontal: 5, vertical: 5),
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(20),
                          color: CustomStyle.color1,
                        ),
                        child: Center(
                            child: Text('Submit',
                                style: TextStyle(
                                    color: Colors.white,
                                    fontWeight: FontWeight.bold))),
                      ),
                    ),
                  ),
                ],
              )
            ],
          );
        });
  }
}
