import 'package:absenkuv3/Bloc/Kpi/KpiApproval/GetDataPengajuanAspekKepribadianBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiApprovalTeam/HalamanPengajuanApprovalKpiTeam/PengajuanAspekKepribadian/komponen/komponenpengajuanaspekkepribadian.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanPengajuanAspekKepribadian extends StatefulWidget {
  var data;
  HalamanPengajuanAspekKepribadian(this.data);

  @override
  State<HalamanPengajuanAspekKepribadian> createState() =>
      _HalamanPengajuanAspekKepribadianState();
}

class _HalamanPengajuanAspekKepribadianState
    extends State<HalamanPengajuanAspekKepribadian> {
  @override
  void initState() {
    BlocProvider.of<GetDataPengajuanAspekKepribadianBloc>(context).add(
        GetDataPengajuanAspekKepribadian(
            context,
            ParsingModelKaryawan(
                id_karyawan: widget.data[0],
                id_company: widget.data[1],
                bulan: widget.data[2],
                tahun: widget.data[3])));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(body: BlocBuilder<GetDataPengajuanAspekKepribadianBloc,
            GetDataPengajuanAspekKepribadianState>(
        builder:
            (BuildContext ctk, GetDataPengajuanAspekKepribadianState state) {
      if (state is GetDataPengajuanAspekKepribadianSuccessState) {
        return KomponenPengajuanAspekKepribadian(
            state.data!,
            ParsingModelKaryawan(
                id_karyawan: widget.data[0],
                id_company: widget.data[1],
                bulan: widget.data[2],
                tahun: widget.data[3]));
      } else if (state is DataPengajuanAspekKepribadianProgressState)
        return Center(
          child: CircularProgressIndicator(
            strokeWidth: 8,
          ),
        );
      else
        return Center(
          child: Image.asset(
            ValueImage.noData,
            height: 250,
          ),
        );
    }));
  }
}
