// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables

import 'package:absenkuv3/Repository/Model/Kpi/KpiApproval/mDataAspekKedisiplinan.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
// import 'package:google_fonts/google_fonts.dart';

class DataTabelPengajuanAspekKedisiplinan extends StatelessWidget {
  final DataAspekKedisiplinan? data;
  DataTabelPengajuanAspekKedisiplinan({required this.data});

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        Container(
          padding: EdgeInsets.all(15),
          child: Column(
            children: [
              Table(
                border: TableBorder.all(
                  color: Colors.grey,
                  width: 0.5,
                  borderRadius: BorderRadius.only(
                    topLeft: Radius.circular(10),
                    topRight: Radius.circular(10),
                  ),
                ),
                columnWidths: {
                  0: FixedColumnWidth(100),
                  1: FixedColumnWidth(70),
                },
                defaultVerticalAlignment: TableCellVerticalAlignment.middle,
                children: [
                  TableRow(
                    decoration: BoxDecoration(
                      color: CustomStyle.color1,
                      boxShadow: [
                        BoxShadow(
                          color: Colors.grey.withOpacity(0.3),
                          spreadRadius: 2,
                          blurRadius: 5,
                          offset: Offset(0, 3),
                        )
                      ],
                      borderRadius: BorderRadius.only(
                        topLeft: Radius.circular(10),
                        topRight: Radius.circular(10),
                      ),
                    ),
                    children: [
                      TableCell(
                          child: Center(
                        child: Container(
                          margin: EdgeInsets.all(10),
                          child: Text(
                            'KETERANGAN',

                            style: TextStyle(
                                fontSize: 10,
                                fontWeight: FontWeight.w600,
                                color: Colors.white),
                          ),
                        ),
                      )),
                      TableCell(
                        child: Center(
                          child: Container(
                            margin: EdgeInsets.all(13),
                            child: Text(
                              'JML',
                              style: TextStyle(
                                  fontSize: 10,
                                  fontWeight: FontWeight.w600,
                                  color: Colors.white),
                            ),
                          ),
                        ),
                      ),
                      TableCell(
                          child: Center(
                        child: Container(
                          margin: EdgeInsets.all(13),
                          child: Text(
                            'POIN',
                            style: TextStyle(
                                fontSize: 10,
                                fontWeight: FontWeight.w600,
                                color: Colors.white),
                          ),
                        ),
                      )),
                      TableCell(
                          child: Center(
                        child: Container(
                          margin: EdgeInsets.all(13),
                          child: Text(
                            'BOBOT',
                            style: TextStyle(
                                fontSize: 10,
                                fontWeight: FontWeight.w600,
                                color: Colors.white),
                          ),
                        ),
                      )),
                      TableCell(
                          child: Center(
                        child: Container(
                          margin: EdgeInsets.all(13),
                          child: Text(
                            'SKOR',
                            style: TextStyle(
                                fontSize: 10,
                                fontWeight: FontWeight.w600,
                                color: Colors.white),
                          ),
                        ),
                      )),
                    ],
                  ),
                  ...berRows(context, data!),
                ],
              ),
              Table(
                border: TableBorder(
                  top: BorderSide.none,
                  left: BorderSide(
                    color: Colors.grey.shade400,
                    // width: 0.5,
                  ),
                  verticalInside: BorderSide(
                    color: Colors.grey,
                    width: 0.5,
                  ),
                  bottom: BorderSide(
                    color: Colors.grey,
                    width: 0.5,
                  ),
                  right: BorderSide(
                    color: Colors.grey,
                    width: 0.5,
                  ),
                  borderRadius: BorderRadius.only(
                    bottomLeft: Radius.circular(20),
                    bottomRight: Radius.circular(20),
                  ),
                ),
                columnWidths: {
                  // 0: FixedColumnWidth(100),
                  1: FixedColumnWidth(70.5),
                  // 2: FixedColumnWidth(70),
                  //   // 3: FixedColumnWidth(70),
                  //   // 4: FixedColumnWidth(70),
                },
                defaultVerticalAlignment: TableCellVerticalAlignment.middle,
                children: [
                  TableRow(
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.only(
                          bottomLeft: Radius.circular(10),
                          bottomRight: Radius.circular(10),
                        ),
                      ),
                      children: [
                        TableCell(
                            child: Center(
                          child: Container(
                            margin: EdgeInsets.all(10),
                            child: Text(
                              'Total Skor',
                              style: TextStyle(
                                  fontSize: 12,
                                  fontWeight: FontWeight.w600,
                                  color: Colors.black),
                            ),
                          ),
                        )),
                        TableCell(
                          child: Center(
                            child: Padding(
                              padding: EdgeInsets.all(13),
                              child: Text(
                                data!.jumlahSkor!,
                                textAlign: TextAlign.center,
                                style: TextStyle(fontWeight: FontWeight.bold),
                              ),
                            ),
                          ),
                        ),
                      ])
                ],
              )
            ],
          ),
        )
      ],
    );
  }

  List<TableRow> berRows(BuildContext context, ber) {
    List<TableRow> rows = [];
    for (Item skorData in ber.item ?? []) {
      Color cellColor = Colors.black;
      // if (skorData.button == true) {
      //   cellColor = const Color(0xFF27AE60);
      // }
      TableRow row = TableRow(
        children: [
          TableCell(
            child: Container(
              margin: EdgeInsets.all(8),
              child: Text(
                skorData.keterangan.toString(),
                // style: TextStyle(color: Colors.black),
                // style: GoogleFonts.workSans(
                //     fontSize: 12,
                //     fontWeight: FontWeight.w400,
                //     color: Colors.black),
                maxLines: 2,
              ),
            ),
          ),
          TableCell(
            // child: Center(
            child: Container(
              // color: Colors.black,
              width: 40,
              height: 40,
              // margin: EdgeInsets.all(13),
              child:
                  //  skorData.button == true
                  //     ? TableRowInkWell(
                  //         onTap: () {
                  //           // BlocProvider.of<NavigatorBloc>(context)
                  //           //     .add(NavigateToListTerlambatSkor(context, [
                  //           //   skorData.jenis!,
                  //           //   skorData.tahun.toString(),
                  //           //   skorData.bulan.toString(),
                  //           //   skorData.keterangan.toString(),
                  //           //   skorData.namaBulan.toString()
                  //           // ]));
                  //           print(
                  //               'Cell tapped for jumlah: ${skorData.jumlah} ${skorData.bulan} ${skorData.tahun}');
                  //         },
                  //         child: Center(
                  //           child: Text(
                  //             skorData.jumlah?.toString() ?? '',
                  //             style: TextStyle(
                  //               color: cellColor,
                  //               fontFamily: FontWeight.w900.toString(),
                  //             ),
                  //           ),
                  //         ))
                  //     :
                  Center(child: Text(skorData.jumlah?.toString() ?? '')),
            ),
            // ),
          ),
          TableCell(
            child: Center(
              child: Container(
                margin: EdgeInsets.all(13),
                child: Text(
                  skorData.poin.toString(),
                  style: TextStyle(color: Colors.black),
                ),
              ),
            ),
          ),
          TableCell(
            child: Center(
              child: Container(
                margin: EdgeInsets.all(13),
                child: Text(
                  '${skorData.bobot}%',
                  style: TextStyle(color: Colors.black),
                ),
              ),
            ),
          ),
          TableCell(
            child: Center(
              child: Container(
                margin: EdgeInsets.all(13),
                child: Text(
                  skorData.skor.toString(),
                  style: TextStyle(color: Colors.black),
                ),
              ),
            ),
          ),
        ],
      );
      rows.add(row);
    }
    return rows;
  }
}
