// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables, must_be_immutable
import 'package:absenkuv3/Bloc/Koordinator/MonitorAbsensi/BadgeMonitorAbsenBloc.dart';
import 'package:absenkuv3/Bloc/Koordinator/MonitorAbsensi/MonitorAbsenBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mMonitorAbsenPage.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/KlienKoordinator/MonitorAbsensiDashboard/KomponenMonitorIzinAbsen.dart';
import 'package:absenkuv3/UI/Modul/MonitorAbsensi/KomponenMonitorAbsen/KomponenMonitorAbsen.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

class HalamanListMonitorAbsensiKlien extends StatefulWidget {
  var data;

  HalamanListMonitorAbsensiKlien(this.data);

  @override
  State<HalamanListMonitorAbsensiKlien> createState() =>
      _HalamanListMonitorAbsensiKlienState();
}

class _HalamanListMonitorAbsensiKlienState
    extends State<HalamanListMonitorAbsensiKlien> {
  String? idSelected;
  double? initialPosition;
  ScrollController _scrollController = new ScrollController();
  @override
  void initState() {
    print(widget.data[1]);
    _scrollController.addListener(() =>
        BlocProvider.of<MonitorAbsenKlienBloc>(context).add(loadMoreEvent(
            _scrollController, idSelected!, '12', widget.data[2])));
    super.initState();
  }

  Future<bool> keluar() async {
    Navigator.pop(context);
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateRemoveToDashboard(context));
    return false;
  }

  @override
  Widget build(BuildContext context) {
    PageMonitorAbsenModel? data = widget.data[1];
    return WillPopScope(
        onWillPop: keluar,
        child: Scaffold(
            appBar: AppBar(
              title: Text(
                data!.menuMonitorAbsensi!.title.toString(),
                style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
              ),
              centerTitle: true,
              flexibleSpace: Image(
                image: AssetImage(ValueImage.headerBiruDashboard),
                fit: BoxFit.cover,
              ),
              actions: const [],
            ),
            body: Stack(children: [
              Container(
                color: Colors.transparent,
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    Container(
                      color: Colors.transparent,
                      height: 50,
                      width: MediaQuery.of(context).size.width,
                      child: Padding(
                          padding: const EdgeInsets.only(top: 5),
                          child: BlocBuilder<BadgeMonitorAbsenKlienBloc,
                              BadgeMonitorAbsenKlienState>(
                            builder: (context, state) {
                              if (state is GetSuccessBadgeMonitor) {
                                if (idSelected == null) {
                                  idSelected = widget.data[0];
                                  BlocProvider.of<MonitorAbsenKlienBloc>(
                                          context)
                                      .add(GetMonitorAbsenKlienEvent(context,
                                          idSelected!, '12', widget.data[2]));
                                }
                                if (idSelected == 'S') {
                                  initialPosition =
                                      MediaQuery.of(context).size.width;
                                } else if (idSelected == 'C') {
                                  initialPosition =
                                      MediaQuery.of(context).size.width;
                                } else {
                                  initialPosition = 0;
                                }
                                ScrollController _controller = ScrollController(
                                    initialScrollOffset: initialPosition!);
                                return ListView.builder(
                                    controller: _controller,
                                    itemCount: state.dataColumn!.data!.length,
                                    scrollDirection: Axis.horizontal,
                                    itemBuilder: (BuildContext context, index) {
                                      return Row(
                                        children: [
                                          Row(
                                            children: [
                                              Stack(
                                                children: [
                                                  Row(
                                                    children: [
                                                      SizedBox(
                                                        width: 5,
                                                      ),
                                                      ChoiceChip(
                                                        shape: RoundedRectangleBorder(
                                                            side: BorderSide(
                                                                color:
                                                                    CustomStyle
                                                                        .color1,
                                                                strokeAlign: 1),
                                                            borderRadius: BorderRadius.only(
                                                                topRight: Radius
                                                                    .circular(
                                                                        12),
                                                                bottomRight:
                                                                    Radius
                                                                        .circular(
                                                                            12),
                                                                topLeft: Radius
                                                                    .circular(
                                                                        12),
                                                                bottomLeft: Radius
                                                                    .circular(
                                                                        12))),
                                                        backgroundColor:
                                                            Colors.transparent,
                                                        labelPadding:
                                                            EdgeInsets.only(
                                                                left: 10,
                                                                right: 10),
                                                        selectedColor:
                                                            CustomStyle.color1,
                                                        selected: idSelected ==
                                                            state
                                                                .dataColumn!
                                                                .data![index]
                                                                .key,
                                                        label: Container(
                                                          child: Row(
                                                            children: [
                                                              Text(state
                                                                      .dataColumn!
                                                                      .data![
                                                                          index]
                                                                      .nama ??
                                                                  ''),
                                                              state
                                                                          .dataColumn!
                                                                          .data![
                                                                              index]
                                                                          .jumlah !=
                                                                      0
                                                                  ? Row(
                                                                      children: [
                                                                        SizedBox(
                                                                          width:
                                                                              5,
                                                                        ),
                                                                        Container(
                                                                          child:
                                                                              Center(
                                                                            child:
                                                                                Text(
                                                                              state.dataColumn!.data![index].jumlah.toString(),
                                                                              style: TextStyle(color: Colors.white),
                                                                            ),
                                                                          ),
                                                                          decoration:
                                                                              new BoxDecoration(
                                                                            color:
                                                                                Colors.red,
                                                                            shape:
                                                                                BoxShape.circle,
                                                                          ),
                                                                          height:
                                                                              MediaQuery.of(context).size.width * 0.05,
                                                                          width:
                                                                              MediaQuery.of(context).size.width * 0.05,
                                                                        )
                                                                      ],
                                                                    )
                                                                  : Text('')
                                                            ],
                                                          ),
                                                        ),
                                                        labelStyle: TextStyle(
                                                            color: idSelected ==
                                                                    state
                                                                        .dataColumn!
                                                                        .data![
                                                                            index]
                                                                        .key
                                                                ? Colors.white
                                                                : CustomStyle
                                                                    .color1),
                                                        elevation: 1,
                                                        onSelected: (_) {
                                                          setState(() {
                                                            idSelected = state
                                                                .dataColumn!
                                                                .data![index]
                                                                .key!;
                                                            BlocProvider.of<
                                                                        MonitorAbsenKlienBloc>(
                                                                    context)
                                                                .add(GetMonitorAbsenKlienEvent(
                                                                    context,
                                                                    idSelected!,
                                                                    '12',
                                                                    widget.data[
                                                                        2]));
                                                          });
                                                        },
                                                      ),
                                                    ],
                                                  ),
                                                ],
                                              )
                                            ],
                                          )
                                        ],
                                      );
                                    });
                              } else {
                                return Container();
                              }
                            },
                          )),
                    )
                  ],
                ),
              ),
              Padding(
                  padding: EdgeInsets.only(top: 60),
                  child: BlocBuilder<MonitorAbsenKlienBloc,
                          MonitorAbsenKlienState>(
                      builder:
                          (BuildContext context, MonitorAbsenKlienState state) {
                    if (state is SuccessMonitorAbsenKlienState ||
                        state is LoadMoreProgressState) {
                      return Stack(
                        children: <Widget>[
                          ListView.builder(
                            physics: AlwaysScrollableScrollPhysics(),
                            shrinkWrap: true,
                            controller: _scrollController,
                            itemCount: state.dataMonitorAbsen!.length,
                            itemBuilder: (BuildContext context, index) {
                              return idSelected == 'A' || idSelected == 'T'
                                  ? CardMonitorAbsen(
                                      state.dataMonitorAbsen![index],
                                      data,
                                      state.jenis_data)
                                  : CardMonitorIzinAbsenKlien(
                                      state.dataMonitorAbsen![index],
                                      data,
                                      widget.data[2]);
                            },
                          ),
                        ],
                      );
                    } else if (state is ProgressMonitorAbsenKlienState) {
                      return Container(
                        height: CustomStyle.formHeight,
                        width: MediaQuery.of(context).size.width,
                        child: Shimmer.fromColors(
                          baseColor: Colors.grey[200]!,
                          highlightColor: Colors.white,
                          period: Duration(seconds: 4),
                          child: Card(),
                        ),
                      );
                    } else {
                      return Center(
                        child: Image.asset(
                          ValueImage.noData,
                          height: 250,
                        ),
                      );
                    }
                  })),
            ])));
  }
}
