// ignore_for_file: must_be_immutable

import 'package:absenkuv3/Bloc/MonitorAbsensi/MonitorListBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataAbsensiPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Absensi/KomponenAbsensi.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListMonitor extends StatefulWidget {
  var data;
  HalamanListMonitor(this.data);

  @override
  State<HalamanListMonitor> createState() => _HalamanListMonitorState();
}

class _HalamanListMonitorState extends State<HalamanListMonitor> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  @override
  void initState() {
    BlocProvider.of<MonitorListBloc>(context).add(GetMonitorListEvent(
        context, widget.data[0], ModelFilter(monthYear: widget.data[1])));
    _scrollController.addListener(() =>
        BlocProvider.of<MonitorListBloc>(context).add(loadMoreEvent(
            context, scaffoldKey, _scrollController, widget.data[0])));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageDataAbsensiModel>(
        future: PengaturanBahasa().dataAbsensi(),
        builder: (context, snapshot) {
          if (snapshot.connectionState == ConnectionState.done) {
            return Scaffold(
                key: scaffoldKey,
                appBar: AppBar(
                  title: Text(
                    snapshot.data!.menuDataAbsensi!.title.toString(),
                    style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                  ),
                  centerTitle: true,
                  flexibleSpace: Image(
                    image: AssetImage(ValueImage.headerBiruDashboard),
                    fit: BoxFit.cover,
                  ),
                ),
                body: Stack(
                  children: [
                    BlocBuilder<MonitorListBloc, MonitorListState>(builder:
                        (BuildContext context, MonitorListState state) {
                      if (state is SuccessMonitorListState ||
                          state is LoadMoreProgressState) {
                        return Stack(
                          children: [
                            ListView.builder(
                                physics: AlwaysScrollableScrollPhysics(),
                                controller: _scrollController,
                                itemCount: state.dataMonitorList!.length,
                                itemBuilder: (BuildContext context, index) {
                                  return CardAbsensi(
                                      state.dataMonitorList![index],
                                      snapshot.data!);
                                }),
                            state is LoadMoreProgressState
                                ? Positioned(
                                    bottom: 16,
                                    child: Container(
                                        width:
                                            MediaQuery.of(context).size.width,
                                        child: Center(
                                            child: CircularProgressIndicator(
                                          strokeWidth: 8,
                                        ))))
                                : Container(),
                          ],
                        );
                      } else if (state is ProgressMonitorListState) {
                        return Center(
                          child: CircularProgressIndicator(
                            strokeWidth: 8,
                          ),
                        );
                      } else {
                        return Center(
                          child: Image.asset(
                            ValueImage.noData,
                            height: 250,
                          ),
                        );
                      }
                    })
                  ],
                ));
          } else {
            return Container();
          }
        });
  }
}
