// ignore_for_file: must_be_immutable

import 'package:absenkuv3/Bloc/MonitorAbsensi/MonitorListLemburBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mLemburPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Lembur/KomponenLembur.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListLemburMonitor extends StatefulWidget {
  var data;
  HalamanListLemburMonitor(this.data);

  @override
  State<HalamanListLemburMonitor> createState() =>
      _HalamanListLemburMonitorState();
}

class _HalamanListLemburMonitorState extends State<HalamanListLemburMonitor> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  @override
  void initState() {
    BlocProvider.of<MonitorListLemburBloc>(context).add(
        GetMonitorListLemburEvent(
            context, ModelFilter(monthYear: widget.data[0])));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageLemburModel>(
        future: PengaturanBahasa().lembur(),
        builder: (context, snapshot) {
          if (snapshot.connectionState == ConnectionState.done) {
            return Scaffold(
                appBar: AppBar(
                  title: Text(
                    snapshot.data!.menuLembur!.tabSaya!,
                    style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                  ),
                  centerTitle: true,
                  flexibleSpace: Image(
                    image: AssetImage(ValueImage.headerBiruDashboard),
                    fit: BoxFit.cover,
                  ),
                ),
                body: Stack(
                  children: [
                    BlocBuilder<MonitorListLemburBloc,
                            MonitorListLemburMonitorState>(
                        builder: (BuildContext context,
                            MonitorListLemburMonitorState state) {
                      if (state is SuccessMonitorListLemburMonitorState) {
                        return Stack(
                          children: [
                            ListView.builder(
                                physics: AlwaysScrollableScrollPhysics(),
                                controller: _scrollController,
                                itemCount: state.data!.length,
                                itemBuilder: (BuildContext context, index) {
                                  return CardLembur(
                                      state.data![index],
                                      'lemburSaya',
                                      scaffoldKey,
                                      snapshot.data!);
                                }),
                            state is LoadMoreProgressState
                                ? Positioned(
                                    bottom: 16,
                                    child: Container(
                                        width:
                                            MediaQuery.of(context).size.width,
                                        child: Center(
                                            child: CircularProgressIndicator(
                                          strokeWidth: 8,
                                        ))))
                                : Container(),
                          ],
                        );
                      } else if (state
                          is ProgressMonitorListLemburMonitorState) {
                        return Center(
                          child: CircularProgressIndicator(
                            strokeWidth: 8,
                          ),
                        );
                      } else {
                        return Center(
                          child: Image.asset(
                            ValueImage.noData,
                            height: 250,
                          ),
                        );
                      }
                    })
                  ],
                ));
          } else {
            return Container();
          }
        });
  }
}
