import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mAktivitasPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'HalamanListAktivitasKlien.dart';

class ParentTabAktivitasKlien extends StatelessWidget {
  final String idKlien;
  ParentTabAktivitasKlien({required this.idKlien});
  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageAktivitasModel>(
        future: PengaturanBahasa().aktivitas(),
        builder: (context, snapshot) {
          if (snapshot.connectionState == ConnectionState.done) {
            return BlocBuilder<AuthBloc, LoginRespon>(
                builder: (BuildContext context, LoginRespon loginRespon) {
              return Scaffold(
                appBar: AppBar(
                  centerTitle: true,
                  flexibleSpace: Image(
                    image: AssetImage(ValueImage.headerBiruDashboard),
                    fit: BoxFit.cover,
                  ),
                  backgroundColor: Colors.transparent,
                  title: Text(
                    snapshot.data!.menuAktivitas!.title!,
                    style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                  ),
                ),
                body: HalamanListAktivitasKlien(snapshot.data!, idKlien),
              );
            });
          } else {
            return CircularProgressIndicator(strokeWidth: 8);
          }
        });
  }

  popupPilihSumberFoto(context, String language) {
    showModalBottomSheet(
      showDragHandle: true,
      isScrollControlled: true,
      shape: RoundedRectangleBorder(
        borderRadius: BorderRadius.only(
          topLeft: Radius.circular(30.0),
          topRight: Radius.circular(30.0),
        ),
      ),
      backgroundColor: Colors.white,
      context: context,
      builder: (ctx) {
        return Column(
          crossAxisAlignment: CrossAxisAlignment.stretch,
          mainAxisSize: MainAxisSize.min,
          children: [
            Container(
                margin: EdgeInsets.only(left: 20),
                child: Text(
                  language == 'id'
                      ? "Tambah Laporan Kinerja"
                      : "Create Report Performanece",
                  style: TextStyle(fontSize: 17, fontWeight: FontWeight.bold),
                )),
            Divider(),
            Padding(
              padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
              child: Column(
                children: [
                  GestureDetector(
                    onTap: () async {
                      BlocProvider.of<NavigatorBloc>(context)
                          .add(NavigateToPengajuanAktivitas(context));
                      Navigator.pop(context);
                    },
                    child: Container(
                      padding: EdgeInsets.all(16),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(12),
                        color: Colors.grey[200],
                      ),
                      child: Row(
                        children: [
                          Icon(Icons.camera_alt, size: 30),
                          SizedBox(width: 16),
                          Expanded(
                            child: Text(
                              language == 'id'
                                  ? "Ambil dari Kamera"
                                  : "Take from camera",
                              style: TextStyle(fontSize: 18),
                              overflow: TextOverflow.ellipsis,
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                  SizedBox(height: 24),
                  GestureDetector(
                    onTap: () async {
                      BlocProvider.of<NavigatorBloc>(context)
                          .add(NavigateToPengajuanAktivitasForm(context));
                      Navigator.pop(context);
                    },
                    child: Container(
                      padding: EdgeInsets.all(16),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(12),
                        color: Colors.grey[200],
                      ),
                      child: Row(
                        children: [
                          Icon(Icons.image, size: 30),
                          SizedBox(width: 16),
                          Expanded(
                            child: Text(
                              language == 'id'
                                  ? "Ambil dari Galeri"
                                  : "Select from Gallery",
                              style: TextStyle(fontSize: 18),
                              overflow: TextOverflow.ellipsis,
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ],
        );
      },
    );
  }
}
