// ignore_for_file: must_be_immutable

import 'package:absenkuv3/Bloc/Koordinator/LaporanKinerja/AktivitasBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mAktivitasPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Aktivitas/KomponenAktivitas2.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/FilterToggle/UI/templateFilterTogle.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListAktivitasKlien extends StatefulWidget {
  PageAktivitasModel redaksional;
  String idKlien;
  HalamanListAktivitasKlien(this.redaksional, this.idKlien);

  @override
  _HalamanListAktivitasKlienState createState() =>
      _HalamanListAktivitasKlienState();
}

class _HalamanListAktivitasKlienState extends State<HalamanListAktivitasKlien> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context)
        .add(SetDate([DateTime.now(), DateTime.now()]));
    BlocProvider.of<AktivitasKlienBloc>(context)
        .add(getListAktivitasKlienEvent(context, null, widget.idKlien));
    _scrollController.addListener(() =>
        BlocProvider.of<AktivitasKlienBloc>(context).add(loadMoreEvent(
            context, scaffoldKey, _scrollController, widget.idKlien)));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: Stack(
        children: [
          BlocBuilder<AktivitasKlienBloc, AktivitasKlienState>(
              builder: (BuildContext context, AktivitasKlienState state) {
            if (state is getListAktivitasSuccessState ||
                state is LoadMoreProgressState)
              return Stack(
                children: <Widget>[
                  ListView.builder(
                      physics: AlwaysScrollableScrollPhysics(),
                      controller: _scrollController,
                      itemCount: state.data!.length,
                      itemBuilder: (BuildContext context, index) {
                        return CardAktivitas2(state.data![index], scaffoldKey,
                            'aktivitasSaya', widget.redaksional);
                      }),
                  state is LoadMoreProgressState
                      ? Positioned(
                          bottom: 16,
                          child: Container(
                              width: MediaQuery.of(context).size.width,
                              child: Center(
                                  child: CircularProgressIndicator(
                                strokeWidth: 8,
                              ))))
                      : Container(),
                ],
              );
            else if (state is AktivitasKlienProgressState)
              return Center(
                child: CircularProgressIndicator(
                  strokeWidth: 8,
                ),
              );
            else
              return Center(
                child: Image.asset(
                  ValueImage.noData,
                  height: 250,
                ),
              );
          }),
          Positioned(
            bottom: 16,
            right: 14,
            child: BlocListener<DateRangePickerBloc, DateRangePickerState>(
              listener: (BuildContext context,
                  DateRangePickerState dateRangePickerState) {
                if (dateRangePickerState is DateAvailable)
                  BlocProvider.of<AktivitasKlienBloc>(context).add(
                      getListAktivitasKlienEvent(
                          context,
                          ModelFilter(dateRange: dateRangePickerState.date),
                          widget.idKlien));
              },
              child: TemplateFilterToggle(),
            ),
          ),
        ],
      ),
    );
  }
}
