// ignore_for_file: unnecessary_null_comparison
import 'package:absenkuv3/Bloc/Cuti/GetDataPeriodeCutiBloc.dart';
import 'package:absenkuv3/Bloc/Izin/IzinBloc.dart';
import 'package:absenkuv3/Bloc/Izin/SisaCutiBloc.dart';
import 'package:absenkuv3/Bloc/Koordinator/Izin/IzinPegawaiBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mIzinPage.dart';
import 'package:absenkuv3/Repository/Model/mIzin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Modul/Aktivitas/KomponenAktivitas.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateConfirmationDialog.dart';
import 'package:absenkuv3/UI/Template/templateConfirmationDialogV2.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

class CardIzinKlien extends StatefulWidget {
  final DataIzin data;
  final String konteks;
  final GlobalKey<ScaffoldState> scaffoldKey;
  final PageIzinModel redaksional;
  final bool? izinPegawai;
  final String? idKlien;
  final BuildContext contextSebelum;
  final BuildContext contextKoordinator;

  CardIzinKlien(this.data, this.konteks, this.scaffoldKey, this.redaksional,
      this.idKlien, this.contextSebelum, this.contextKoordinator,
      {this.izinPegawai = false});

  @override
  _CardIzinKlienState createState() => _CardIzinKlienState();
}

class _CardIzinKlienState extends State<CardIzinKlien> {
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () => BlocProvider.of<NavigatorBloc>(context)
          .add(NavigateToDetailIzinKlien(context, [
        widget.data.idIzin,
        widget.konteks,
        widget.izinPegawai,
        'komponen',
        widget.idKlien,
        widget.contextSebelum,
        widget.contextKoordinator,
      ])),
      child: Container(
        decoration: CustomStyle.boxDecoration,
        padding: EdgeInsets.all(16),
        margin: EdgeInsets.all(8),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(children: [
              Container(
                padding: EdgeInsets.symmetric(horizontal: 8),
                child: Row(
                  children: [
                    Column(
                      children: [
                        Text(
                          widget.data.jumlahIzin.toString(),
                          style: TextStyle(
                              fontSize: 16, fontWeight: FontWeight.w600),
                        ),
                        Text(
                          widget.redaksional.menuIzin!.data!.hari!,
                          style: TextStyle(
                              fontSize: 12,
                              fontWeight: FontWeight.w400,
                              color: CustomStyle.fontColorGrey),
                        )
                      ],
                    ),
                    VDivider(),
                  ],
                ),
              ),
              Expanded(
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Expanded(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            widget.data.tglIzin.toString(),
                            style: TextStyle(
                                fontSize: 13, fontWeight: FontWeight.w600),
                          ),
                          SizedBox(
                            height: 4,
                          ),
                          Row(
                            children: [
                              TemplateButton(
                                label: widget.data.jenisIzin!,
                                color:
                                    Color(int.parse(widget.data.warnaBgIzin!)),
                                contentColor: Color(
                                    int.parse(widget.data.warnaFontIzin!)),
                                fontSize: 10,
                                radius: 2,
                                paddingTopBottom: 4,
                                heightButton: 30,
                                bold: true,
                                paddingLeftRight: 4,
                              ),
                              SizedBox(
                                width: 8,
                              ),
                              Text(
                                widget.data.status!,
                                style: TextStyle(
                                    fontSize: 12,
                                    fontWeight: FontWeight.w400,
                                    color: Color(
                                        int.parse(widget.data.warnaStatus!))),
                              )
                            ],
                          ),
                        ],
                      ),
                    ),
                    PopupMenuButton<String>(
                      onSelected: (value) => doAction(context, value),
                      itemBuilder: (BuildContext context) {
                        return actionMenu();
                      },
                      child: Icon(
                        Icons.more_vert_sharp,
                        color: CustomStyle.fontColorGrey,
                      ),
                    )
                  ],
                ),
              ),
            ]),
            Divider(
              thickness: 2,
            ),
            SizedBox(
              height: 8,
            ),
            widget.izinPegawai!
                ? Column(
                    children: [
                      Text(
                        widget.data.nama!,
                        style: TextStyle(
                            fontSize: 13, fontWeight: FontWeight.w600),
                      ),
                      SizedBox(
                        height: 8,
                      ),
                    ],
                  )
                : Container(),
            Row(
              children: [
                Text(
                  "${widget.redaksional.menuIzin!.data!.tanggalPengajuan} : ",
                  style: TextStyle(
                      fontSize: 12,
                      color: CustomStyle.fontColorGrey,
                      fontWeight: FontWeight.w400),
                ),
                Text(
                  widget.data.tglPengajuan!,
                  style: TextStyle(fontSize: 12, fontWeight: FontWeight.w600),
                ),
              ],
            ),
          ],
        ),
      ),
    );
  }

  actionMenu() {
    List<String> buttonAksi;
    if (widget.konteks == 'izinSaya' && widget.data.aksiBatalkan!)
      buttonAksi = [
        '${widget.redaksional.menuIzin!.button!.detail}',
        '${widget.redaksional.menuIzin!.button!.batalkan}'
      ];
    else if (widget.konteks == 'izinPegawai' &&
        widget.data.aksi! &&
        !widget.data.buttonApprovalHrd!)
      buttonAksi = [
        '${widget.redaksional.menuIzin!.button!.detail}',
        '${widget.redaksional.menuIzin!.button!.setujui}',
        '${widget.redaksional.menuIzin!.button!.tolak}'
      ];
    else if (widget.konteks == 'izinPegawai' &&
        widget.data.aksi! &&
        widget.data.buttonApprovalHrd!)
      buttonAksi = [
        '${widget.redaksional.menuIzin!.button!.detail}',
        '${widget.redaksional.menuIzin!.button!.setujuiSemua}',
        '${widget.redaksional.menuIzin!.button!.tolakSemua}'
      ];
    else
      buttonAksi = ['${widget.redaksional.menuIzin!.button!.detail}'];
    return buttonAksi.map((String choice) {
      return PopupMenuItem<String>(
        value: choice,
        child: Text(choice),
      );
    }).toList();
  }

  void doAction(BuildContext context, String value) {
    if (value == '${widget.redaksional.menuIzin!.button!.batalkan}')
      TemplateConfirmationDialog(
          '${widget.redaksional.menuIzin!.pesanKonfirmasi!.batalkan}',
          () => BlocProvider.of<IzinBloc>(context).add(
              batalkanIzin(widget.data.idIzin, context, widget.scaffoldKey)),
          context);
    else if (value == '${widget.redaksional.menuIzin!.button!.setujui}') {
      TemplateConfirmationDialogV2(
          '${widget.redaksional.menuIzin!.pesanKonfirmasi!.setujui}',
          () => {
                BlocProvider.of<IzinPegawaiKlienBloc>(context).add(setujuiIzin(
                  widget.data.idIzin,
                  context,
                  widget.scaffoldKey,
                  'listIzinPegawai',
                  widget.idKlien!,
                  widget.contextSebelum,
                  widget.contextKoordinator,
                )),
              },
          context,
          icon: Container(
            width: 70,
            height: 70,
            margin: EdgeInsets.only(bottom: 15),
            decoration: BoxDecoration(
              border: Border.all(color: Colors.blue, width: 3),
              shape: BoxShape.circle, // Membuat lingkaran
            ),
            child: Icon(
              Icons.question_mark_rounded,
              color: Colors.blue, // Warna ikon
              size: 40, // Ukuran ikon
            ),
          ),
          addWidget: Column(
            children: [
              SizedBox(
                height: 10,
              ),
              Container(
                padding: EdgeInsets.all(10),
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(5),
                    color: CustomStyle.colorGreySoft),
                width: MediaQuery.of(context).size.width,
                child: Column(
                  children: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Text('${widget.redaksional.menuIzin!.data!.jumlahIzin}',
                            style: TextStyle(
                                fontSize: CustomStyle.fontSizeNormal - 1,
                                color: CustomStyle.colorGreyDop)),
                        Text('${widget.data.jumlahIzin}',
                            style: TextStyle(
                                fontSize: CustomStyle.fontSizeNormal - 1))
                      ],
                    ),
                    SizedBox(
                      height: 7,
                    ),
                    BlocProvider<SisaCutiBloc>(
                      create: (context) {
                        return SisaCutiBloc(SisaCutiProgress());
                      },
                      child: WidgetSisaCutiV2(
                          widget.data.idKaryawan,
                          widget.redaksional.menuIzin!.data!
                              .infoSisaCutiKaryawan),
                    ),
                    SizedBox(
                      height: 7,
                    ),
                    BlocProvider<GetDataPeriodeCutiBloc>(
                      create: (context) {
                        return GetDataPeriodeCutiBloc(
                            GetDataPeriodeCutiProggres());
                      },
                      child: WidgetPeriodeCuti(
                          widget.data.idKaryawan,
                          widget.redaksional.menuIzin!.data!
                              .infoCutiBerlakuHingga),
                    ),
                  ],
                ),
              ),
              SizedBox(
                height: 10,
              ),
            ],
          ));

      // TemplateConfirmationDialog(
      //     '${widget.redaksional.menuIzin!.pesanKonfirmasi!.setujui}',
      //     () =>
      // BlocProvider.of<IzinPegawaiKlienBloc>(context).add(setujuiIzin(
      //         widget.data.idIzin,
      //         context,
      //         widget.scaffoldKey,
      //         'listIzinPegawai')),
      //     context,
      //     addWidget: Column(
      //       children: [
      //         Divider(
      //           thickness: 1,
      //         ),
      //         BlocProvider<SisaCutiBloc>(
      //           create: (context) {
      //             return SisaCutiBloc(SisaCutiProgress());
      //           },
      //           child: WidgetSisaCuti(widget.data.idKaryawan,
      //               widget.redaksional.menuIzin!.data!.infoSisaCutiKaryawan),
      //         ),
      //         SizedBox(
      //           height: 4,
      //         ),
      //         TemplateRow(
      //           '${widget.redaksional.menuIzin!.data!.jumlahIzin}',
      //           widget.data.jumlahIzin,
      //           null,
      //           CustomStyle.fontColorBlack,
      //           fontSize: CustomStyle.fontSizeNormal - 1,
      //           flex: [10, 6, 0],
      //         ),
      //         Divider(
      //           thickness: 1,
      //         ),
      //       ],
      //     ));
    } else if (value ==
        '${widget.redaksional.menuIzin!.button!.setujuiSemua}') {
      TemplateConfirmationDialogV2(
          '${widget.redaksional.menuIzin!.pesanKonfirmasi!.setujuiSemua}',
          () => {
                BlocProvider.of<IzinPegawaiKlienBloc>(context)
                    .add(MewakiliSetujuiIzin(
                  widget.data.idIzin,
                  context,
                  widget.scaffoldKey,
                  'listIzinPegawai',
                  widget.idKlien!,
                  widget.contextSebelum,
                  widget.contextKoordinator,
                )),
              },
          context,
          icon: Container(
            width: 70,
            height: 70,
            margin: EdgeInsets.only(bottom: 15),
            decoration: BoxDecoration(
              border: Border.all(color: Colors.blue, width: 3),
              shape: BoxShape.circle, // Membuat lingkaran
            ),
            child: Icon(
              Icons.question_mark_rounded,
              color: Colors.blue, // Warna ikon
              size: 40, // Ukuran ikon
            ),
          ),
          addWidget: Column(
            children: [
              SizedBox(
                height: 10,
              ),
              Container(
                padding: EdgeInsets.all(10),
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(5),
                    color: CustomStyle.colorGreySoft),
                width: MediaQuery.of(context).size.width,
                child: Column(
                  children: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Text('${widget.redaksional.menuIzin!.data!.jumlahIzin}',
                            style: TextStyle(
                                fontSize: CustomStyle.fontSizeNormal - 1,
                                color: CustomStyle.colorGreyDop)),
                        Text('${widget.data.jumlahIzin}',
                            style: TextStyle(
                                fontSize: CustomStyle.fontSizeNormal - 1))
                      ],
                    ),
                    SizedBox(
                      height: 7,
                    ),
                    BlocProvider<SisaCutiBloc>(
                      create: (context) {
                        return SisaCutiBloc(SisaCutiProgress());
                      },
                      child: WidgetSisaCutiV2(
                          widget.data.idKaryawan,
                          widget.redaksional.menuIzin!.data!
                              .infoSisaCutiKaryawan),
                    ),
                    SizedBox(
                      height: 7,
                    ),
                    BlocProvider<GetDataPeriodeCutiBloc>(
                      create: (context) {
                        return GetDataPeriodeCutiBloc(
                            GetDataPeriodeCutiProggres());
                      },
                      child: WidgetPeriodeCuti(
                          widget.data.idKaryawan,
                          widget.redaksional.menuIzin!.data!
                              .infoCutiBerlakuHingga),
                    ),
                  ],
                ),
              ),
              SizedBox(
                height: 10,
              ),
            ],
          ));
    } else if (value == '${widget.redaksional.menuIzin!.button!.tolakSemua}')
      TemplateConfirmationDialog(
          '${widget.redaksional.menuIzin!.pesanKonfirmasi!.tolakSemua}',
          () => BlocProvider.of<IzinPegawaiKlienBloc>(context)
                  .add(MewakiliTolakIzin(
                widget.data.idIzin,
                context,
                widget.scaffoldKey,
                'listIzinPegawai',
                widget.idKlien!,
                widget.contextSebelum,
                widget.contextKoordinator,
              )),
          context);
    else if (value == '${widget.redaksional.menuIzin!.button!.tolak}')
      TemplateConfirmationDialog(
          '${widget.redaksional.menuIzin!.pesanKonfirmasi!.tolak}',
          () => BlocProvider.of<IzinPegawaiKlienBloc>(context).add(tolakIzin(
                widget.data.idIzin,
                context,
                widget.scaffoldKey,
                'listIzinPegawai',
                widget.idKlien!,
                widget.contextSebelum,
                widget.contextKoordinator,
              )),
          context);
    else if (value == '${widget.redaksional.menuIzin!.button!.detail}')
      BlocProvider.of<NavigatorBloc>(context).add(NavigateToDetailIzinKlien(
          context, [widget.data.idIzin, widget.konteks, widget.izinPegawai]));
  }
}

class WidgetSisaCuti extends StatefulWidget {
  final String? idKaryawan;
  final String? title;
  WidgetSisaCuti(this.idKaryawan, this.title);

  @override
  _WidgetSisaCutiState createState() => _WidgetSisaCutiState();
}

class _WidgetSisaCutiState extends State<WidgetSisaCuti> {
  @override
  void initState() {
    super.initState();
    BlocProvider.of<SisaCutiBloc>(context)
        .add(GetSisaCutiKaryawan(widget.idKaryawan));
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<SisaCutiBloc, SisaCutiState>(
        builder: (BuildContext context, SisaCutiState state) {
      if (state is SisaCutiSuccess)
        return TemplateRow(
          widget.title!,
          state.basicSimpleRespon != null
              ? state.basicSimpleRespon!.data.toString()
              : '0',
          null,
          CustomStyle.fontColorBlack,
          fontSize: CustomStyle.fontSizeNormal - 1,
          flex: [10, 6, 0],
        );
      else
        return Container(
          height: CustomStyle.formHeight,
          width: MediaQuery.of(context).size.width,
          child: Shimmer.fromColors(
            baseColor: Colors.grey[200]!,
            highlightColor: Colors.white,
            period: Duration(seconds: 4),
            child: Card(),
          ),
        );
    });
  }
}

class WidgetSisaCutiV2 extends StatefulWidget {
  final String? idKaryawan;
  final String? title;
  WidgetSisaCutiV2(this.idKaryawan, this.title);

  @override
  _WidgetSisaCutiV2State createState() => _WidgetSisaCutiV2State();
}

class _WidgetSisaCutiV2State extends State<WidgetSisaCutiV2> {
  @override
  void initState() {
    super.initState();
    BlocProvider.of<SisaCutiBloc>(context)
        .add(GetSisaCutiKaryawan(widget.idKaryawan));
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<SisaCutiBloc, SisaCutiState>(
        builder: (BuildContext context, SisaCutiState state) {
      if (state is SisaCutiSuccess)
        return Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Expanded(
              child: Text('${widget.title!}',
                  style: TextStyle(
                      fontSize: CustomStyle.fontSizeNormal - 1,
                      color: CustomStyle.colorGreyDop)),
            ),
            Text(
                '${state.basicSimpleRespon != null ? state.basicSimpleRespon!.data.toString() : '0'}',
                style: TextStyle(fontSize: CustomStyle.fontSizeNormal - 1))
          ],
        );
      else
        return Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Expanded(
              child: Text('${widget.title!}',
                  style: TextStyle(
                      fontSize: CustomStyle.fontSizeNormal - 1,
                      color: CustomStyle.colorGreyDop)),
            ),
            Text('0',
                style: TextStyle(fontSize: CustomStyle.fontSizeNormal - 1))
          ],
        );
    });
  }
}

class WidgetPeriodeCuti extends StatefulWidget {
  final String? idKaryawan;
  final String? title;
  WidgetPeriodeCuti(this.idKaryawan, this.title);

  @override
  _WidgetPeriodeCutiState createState() => _WidgetPeriodeCutiState();
}

class _WidgetPeriodeCutiState extends State<WidgetPeriodeCuti> {
  @override
  void initState() {
    super.initState();
    BlocProvider.of<GetDataPeriodeCutiBloc>(context)
        .add(GetDataPeriodeCuti(widget.idKaryawan));
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<GetDataPeriodeCutiBloc, GetDataPeriodeCutiState>(
        builder: (BuildContext context, GetDataPeriodeCutiState state) {
      if (state is GetDataPeriodeCutiSuccessState) {
        return Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Expanded(
              child: Text('${widget.title!}',
                  style: TextStyle(
                      fontSize: CustomStyle.fontSizeNormal - 1,
                      color: CustomStyle.colorGreyDop)),
            ),
            Text(
                '${state.respon != null ? state.respon.data!.periodeAkhir : '-'}',
                style: TextStyle(fontSize: CustomStyle.fontSizeNormal - 1))
          ],
        );
      } else
        return Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Expanded(
              child: Text('${widget.title!}',
                  style: TextStyle(
                      fontSize: CustomStyle.fontSizeNormal - 1,
                      color: CustomStyle.colorGreyDop)),
            ),
            Text('-',
                style: TextStyle(fontSize: CustomStyle.fontSizeNormal - 1))
          ],
        );
    });
  }
}

class VDivider extends StatelessWidget {
  const VDivider({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 60,
      margin: EdgeInsets.symmetric(horizontal: 12),
      decoration: BoxDecoration(
        border: Border(
          right: BorderSide(
            color: Theme.of(context).dividerColor,
            width: 2,
          ),
        ),
      ),
    );
  }
}

// class InformasiIzin extends StatefulWidget {
//   final Informasi informasi;
//   final MenuIzin language;
//   InformasiIzin(this.informasi, this.language);

//   @override
//   State<InformasiIzin> createState() => _InformasiIzinState();
// }

// class _InformasiIzinState extends State<InformasiIzin> {
//   @override
//   Widget build(BuildContext context) {
//     double screenWidth = MediaQuery.of(context).size.width;
//     return Container(
//       width: screenWidth * 0.9,
//       margin: EdgeInsets.only(top: 10,bottom: 15),
//       padding: EdgeInsets.symmetric(
//           horizontal: screenWidth * 0.04, vertical: screenWidth * 0.03),
//       decoration: BoxDecoration(
//         borderRadius: BorderRadius.circular(16),
//         color: Color(0x4D56CCF2),
//       ),
//       child: Row(
//         mainAxisAlignment: MainAxisAlignment.spaceAround,
//         crossAxisAlignment: CrossAxisAlignment.start,
//         children: [
//           Expanded(
//             child: Column(
//               crossAxisAlignment: CrossAxisAlignment.start,
//               children: [
//                 TitleValueText(
//                   title: 'Maksimal Izin : ',
//                   value: widget.informasi.maksimalIzin.toString(),
//                 ),
//                 SizedBox(height: 5),
//                 TitleValueText(
//                   title: 'Terhitung : ',
//                   value: widget.informasi.kalender.toString(),
//                 ),
//                 SizedBox(height: 5),
//                 TitleValueText(
//                   title: 'Back Date :',
//                   value: widget.informasi.backDate.toString(),
//                 ),
//               ],
//             ),
//           ),
//           SizedBox(width: screenWidth * 0.04),
//           Expanded(
//             child: Column(
//               crossAxisAlignment: CrossAxisAlignment.start,
//               children: [
//                 TitleValueText(
//                   title: 'File Upload : ',
//                   value: widget.informasi.fileUpload.toString(),
//                 ),
//                 SizedBox(height: 5),
//                 TitleValueText(
//                   title: 'Kurangi Saldo Cuti : ',
//                   value: widget.informasi.mengurangiCuti.toString(),
//                 ),
//               ],
//             ),
//           ),
//         ],
//       ),
//     );
//   }
// }

// class TitleValueText extends StatelessWidget {
//   final String title;
//   final String value;

//   const TitleValueText({Key? key, required this.title, required this.value})
//       : super(key: key);

//   @override
//   Widget build(BuildContext context) {
//     return RichText(
//       text: TextSpan(
//         style: TextStyle(
//           color: Colors.black,
//         ), // Default style for both parts
//         children: [
//           TextSpan(
//             text: title,
//             style: TextStyle(
//                 color: Color(0XFF2F80ED)), // Style for the title
//           ),
//           TextSpan(
//             text: value,
//             style: TextStyle(
//                 fontWeight: FontWeight.bold,
//                 color: Color(0XFF2F80ED)), // Style for the value
//           ),
//         ],
//       ),
//     );
//   }
// }
class InformasiIzin extends StatefulWidget {
  final Informasi informasi;
  final MenuIzin language;
  InformasiIzin(this.informasi, this.language);
  @override
  State<InformasiIzin> createState() => _InformasiIzinState();
}

class _InformasiIzinState extends State<InformasiIzin> {
  @override
  Widget build(BuildContext context) {
    double screenWidth = MediaQuery.of(context).size.width;
    return FutureBuilder(
      future: PengaturanBahasa().getDataBahasa(),
      builder: (BuildContext context, snapshot) {
        if (snapshot.connectionState == ConnectionState.done) {
          String language = snapshot.data.toString();
          return Container(
              width: screenWidth * 1.0,
              margin: EdgeInsets.only(top: 10, bottom: 15),
              padding: EdgeInsets.symmetric(
                  horizontal: screenWidth * 0.04, vertical: screenWidth * 0.03),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(10),
                color: Color(0x4D56CCF2),
              ),
              child: Column(
                children: [
                  _buildKomponen(
                      language == 'id' ? 'Maksimal Izin' : 'Maximum Permit',
                      widget.informasi.maksimalIzin.toString()),
                  _buildKomponen(language == 'id' ? 'Terhitung' : 'Count',
                      widget.informasi.kalender.toString()),
                  _buildKomponen(
                      'Back Date', widget.informasi.backDate.toString()),
                  _buildKomponen(
                      'File Upload', widget.informasi.fileUpload.toString()),
                  _buildKomponen(
                      language == 'id'
                          ? 'Mengurangi Saldo Cuti'
                          : 'Reduce Leave Balance',
                      widget.informasi.mengurangiCuti.toString()),
                ],
              )
              // Row(
              //   crossAxisAlignment: CrossAxisAlignment.start,
              //   children: [
              //     Expanded(
              //       child: Table(
              //         columnWidths: {
              //           0: FlexColumnWidth(3),
              //           1: FixedColumnWidth(10),
              //           2: FlexColumnWidth(3),
              //         },
              //         children: [
              //           _buildTableRow(language =='id'?'Maksimal Izin':'Maximum Permit',
              //               widget.informasi.maksimalIzin.toString()),
              //           _buildTableRow(
              //               language =='id'?'Terhitung':'Count', widget.informasi.kalender.toString()),
              //           _buildTableRow(
              //               'Back Date', widget.informasi.backDate.toString()),
              //         ],
              //       ),
              //     ),
              //     SizedBox(width: screenWidth * 0.02), // Spacing between columns
              //     Expanded(
              //       child: Table(
              //         columnWidths: {
              //           0: FlexColumnWidth(10),
              //           1: FixedColumnWidth(10),
              //           2: FlexColumnWidth(5),
              //         },
              //         children: [
              //           _buildTableRow('File Upload',
              //               widget.informasi.fileUpload.toString()),
              //           _buildTableRow( language =='id'?'Mengurangi Saldo Cuti':'Reduce Leave Balance',
              //               widget.informasi.mengurangiCuti.toString()),
              //         ],
              //       ),
              //     ),
              //   ],
              // ),

              );
        } else {
          return Container();
        }
      },
    );
  }

  Widget _buildKomponen(String title, String value) {
    return Padding(
      padding: const EdgeInsets.symmetric(horizontal: 4, vertical: 4),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Text(title, style: TextStyle(color: Color(0XFF2F80ED))),
          Text(value,
              style: TextStyle(
                  fontWeight: FontWeight.bold, color: Color(0XFF2F80ED))),
        ],
      ),
    );
  }

  TableRow _buildTableRow(String title, String value) {
    return TableRow(
      children: [
        Padding(
          padding: EdgeInsets.symmetric(vertical: 5),
          child: Text(
            '$title',
            style: TextStyle(color: Color(0XFF2F80ED)),
          ),
        ),
        Padding(
          padding: EdgeInsets.symmetric(vertical: 5),
          child: Text(
            ':',
            style: TextStyle(color: Color(0XFF2F80ED)),
          ),
        ),
        Padding(
          padding: EdgeInsets.symmetric(vertical: 5),
          child: Text(
            value,
            style: TextStyle(
                fontWeight: FontWeight.bold, color: Color(0XFF2F80ED)),
          ),
        ),
      ],
    );
  }
}
