import 'package:absenkuv3/Bloc/Koordinator/Izin/BadgeNotifBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mRekapPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/KlienKoordinator/MonitorAbsensiDashboard/MonitorAbsensiDashboard.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateMenu.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class DashboardKlienKoordinator extends StatefulWidget {
  final klien;
  DashboardKlienKoordinator({Key? key, this.klien}) : super(key: key);
  @override
  _DashboardKlienKoordinatorState createState() =>
      _DashboardKlienKoordinatorState();
}

class _DashboardKlienKoordinatorState extends State<DashboardKlienKoordinator> {
  @override
  void initState() {
    print("masuk");
    BlocProvider.of<BadgeNotifKlienBloc>(context)
        .add(GetBadgeKlien(context, widget.klien[1]));
    super.initState();
  }

  Future<bool> keluar() async {
    BlocProvider.of<NavigatorBloc>(context).add(NavigateRemoveToDashboard(context));
    return false;
  }

  Future<bool> keluar2() async {
    BlocProvider.of<NavigatorBloc>(context).add(NavigatePop(context));
    return false;
  }


  @override
  void didChangeDependencies() {
    super.didChangeDependencies();
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageRekapModel>(
        future: PengaturanBahasa().rekap(),
        builder: (context, snapshot) {
          if (snapshot.connectionState == ConnectionState.done) {
            return WillPopScope(
              onWillPop: widget.klien[3]=='dashboard'?keluar:keluar2,
              child: Scaffold(
                backgroundColor: CustomStyle.backgroundColor,
                appBar: AppBar(
                  centerTitle: true,
                  flexibleSpace: Image(
                    image: AssetImage(ValueImage.headerBiruDashboard),
                    fit: BoxFit.cover,
                  ),
                  backgroundColor: Colors.transparent,
                  title: Text(
                    widget.klien[0],
                    style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                  ),
                ),
                body: Container(
                  height: MediaQuery.of(context).size.height - 50,
                  child: SingleChildScrollView(
                    child: Stack(
                      children: [
                        SafeArea(
                          child: Padding(
                            padding: const EdgeInsets.fromLTRB(0, 20, 0, 0),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: <Widget>[
                                SizedBox(
                                  height: 10,
                                ),
                                TemplateMenu(
                                  icon: ValueImage.iconAktivitas,
                                  title: snapshot.data!.menuRekap!.menu!
                                      .dataAktivitas!.title!,
                                  subtitle: snapshot.data!.menuRekap!.menu!
                                      .dataAktivitas!.subtitle!,
                                  onClick: () =>
                                      BlocProvider.of<NavigatorBloc>(context).add(
                                          NavigateToListRekapLaporanKinerjaKlien(
                                    context,
                                    widget.klien[1],
                                  )),
                                ),
                                SizedBox(
                                  height: 10,
                                ),
                                TemplateMenu(
                                  icon: ValueImage.iconAbsensi,
                                  title: snapshot
                                      .data!.menuRekap!.menu!.dataAbsen!.title!,
                                  subtitle: snapshot.data!.menuRekap!.menu!
                                      .dataAbsen!.subtitle!,
                                  onClick: () =>
                                      BlocProvider.of<NavigatorBloc>(context)
                                          .add(NavigateToListRekapAbsensiKlien(
                                    context,
                                    widget.klien[1],
                                  )),
                                ),
                                SizedBox(
                                  height: 10,
                                ),
                                BlocBuilder<BadgeNotifKlienBloc,
                                    BadgeNotifKlienState>(
                                  builder: (context, state) {
                                    int badgeCount = 0;
                                    if (state is GetSuccess) {
                                      badgeCount = state.dataDashboard!.data!;
                                    }
                                    return TemplateMenu(
                                      icon: ValueImage.iconIzin,
                                      title: snapshot.data!.menuRekap!.menu!
                                          .dataIzin!.title!,
                                      subtitle: snapshot.data!.menuRekap!.menu!
                                          .dataIzin!.subtitle!,
                                      onClick: () {
                                        BlocProvider.of<NavigatorBloc>(context)
                                            .add(
                                          NavigateToListIzinKlien(context, [
                                            widget.klien[1],
                                            context,
                                            widget.klien[2]
                                          ]),
                                        );
                                      },
                                      jumlahBadge: badgeCount,
                                    );
                                  },
                                ),
                                SizedBox(
                                  height: 20,
                                ),
                                Padding(
                                  padding: const EdgeInsets.only(left: 20.0),
                                  child: Container(
                                    width: double.infinity,
                                    child: Column(
                                      children: [buildAbsensiHariIni()],
                                    ),
                                  ),
                                )
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
              ),
            );
          } else {
            return CircularProgressIndicator(strokeWidth: 8);
          }
        });
  }

  buildAbsensiHariIni() {
    return Container(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text('Absensi Karyawan Hari Ini',
              style: TextStyle(
                fontSize: CustomStyle.fontSizeSubTitle,
                fontWeight: FontWeight.bold,
              )),
          MonitorAbsensiKlienDashboard(idKlien: widget.klien[1]),
          SizedBox(
            height: 30,
          )
        ],
      ),
    );
  }
}
