import 'package:absenkuv3/Repository/Model/PageModel/mDataAbsensiPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/KlienKoordinator/Absensi/halamanListAbsensiKlien.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';

class ParentTabDataAbsensiKlien extends StatelessWidget {
  final String idKlien;
  ParentTabDataAbsensiKlien({required this.idKlien});
  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageDataAbsensiModel>(
        future: PengaturanBahasa().dataAbsensi(),
        builder: (context, snapshot) {
          if (snapshot.connectionState == ConnectionState.done) {
            return Scaffold(
              appBar: AppBar(
                centerTitle: true,
                flexibleSpace: Image(
                  image: AssetImage(ValueImage.headerBiruDashboard),
                  fit: BoxFit.cover,
                ),
                backgroundColor: Colors.transparent,
                title: Text(
                  snapshot.data!.menuDataAbsensi!.title!,
                  style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                ),
              ),
              body: HalamanListAbsensiKlien(snapshot.data!, idKlien),
            );
          } else {
            return CircularProgressIndicator(strokeWidth: 8);
          }
        });
  }
}
