import 'package:flutter/material.dart';

class CardItemDataGaji extends StatefulWidget {
  final List<Widget> children;
  final String title;
  final String subtitle;
  final String? value;
  final bool? margin;
  final double marginTop;
  final bool bold;
  final double fontSize;
  final bool line;
  CardItemDataGaji(this.title, this.subtitle, this.children, this.bold, this.fontSize, this.line, {this.value, this.margin = false, this.marginTop = 7});
  @override
  _CardItemDataGajiState createState() => _CardItemDataGajiState();
}

class _CardItemDataGajiState extends State<CardItemDataGaji> {
  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(left: 8, right: 8, top: widget.marginTop),
      child: Container(
        // borderRadius: BorderRadius.all(Radius.circular(10)),
        margin: EdgeInsets.only(bottom: widget.margin!
                                          ? widget.line ? 0 : 11
                                          : 0, ),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Text(widget.title, style: TextStyle(fontWeight: widget.bold?FontWeight.w600:FontWeight.normal, fontSize: widget.fontSize),),
                Align(
                    alignment: Alignment.centerRight,
                    child: Text(widget.subtitle, style: TextStyle(fontWeight: widget.bold?FontWeight.w600:FontWeight.normal, fontSize: widget.fontSize),)),
              ],
            ),
            Column(
              children: widget.children
            ),
            widget.line ? Container(
              margin: EdgeInsets.only(top: 9),
                child: Divider(color: Colors.grey)) : Container()
          ],
        ),
      ),
    );
  }
}