import 'package:absenkuv3/Bloc/Dropdown/DropdownStatus.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class DropdownStatus extends StatefulWidget {
  final color;
  final double fontSize;
  final String? initialData;
  final double? formHeight;
  final double radius;
  DropdownStatus(
      {this.initialData,
      this.color = Colors.grey,
      this.fontSize = 14,
      this.formHeight,
      this.radius = 6});

  @override
  _DropdownStatusState createState() => _DropdownStatusState();
}

class _DropdownStatusState extends State<DropdownStatus> {
  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<String>(
        future: PengaturanBahasa().getDataBahasa(),
        builder: (context, snapshot) {
          return Container(
            margin: EdgeInsets.only(bottom: 12),
            child: Column(
              children: [
                BlocBuilder<DropdownStatusBloc, DropdownState>(
                  builder: (BuildContext context, DropdownState state) {
                    if (state is DropdownSuccessState)
                      return Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Padding(
                            padding: const EdgeInsets.only(bottom: 8),
                            child: Text(
                              'Status',
                              style: TextStyle(
                                  color: widget.color,
                                  fontWeight: FontWeight.bold,
                                  fontSize: widget.fontSize),
                            ),
                          ),
                          Container(
                            height: widget.formHeight ?? CustomStyle.formHeight,
                            padding: EdgeInsets.only(right: 12),
                            decoration: BoxDecoration(
                                border: Border.all(
                                    width: 0.8, //
                                    color: CustomStyle
                                        .fontColorBlack! //                  <--- border width here
                                ),
                                borderRadius: new BorderRadius.all(
                                    Radius.circular(widget.radius))),
                            child: DropdownButton(
                              isExpanded: true,
                              underline: Container(),
                              elevation: 2,
                              style: TextStyle(
                                  color: widget.color,
                                  fontSize: 13,
                                  fontWeight: FontWeight.normal),
                              icon: Icon(Icons.keyboard_arrow_down),
                              hint: Container(
                                  padding: EdgeInsets.only(left: 12),
                                  child: Text(
                                    widget.initialData != null
                                        ? widget.initialData!
                                        : snapshot.data == null || snapshot.data == 'en' ? 'All Status' : 'Semua Status',
                                    style: TextStyle(
                                        color: widget.color,
                                        fontWeight: FontWeight.normal),
                                  )),
                              value: state.selectedValue,
                              items: state.dropdownRespon!.data != null &&
                                  state.dropdownRespon!.data!.length > 0
                                  ? state.dropdownRespon!.data!.map((item) {
                                return DropdownMenuItem(
                                  child: Container(
                                      padding: EdgeInsets.only(left: 12),
                                      child: Text(
                                        item.nama!,
                                      )),
                                  value: item,
                                );
                              }).toList()
                                  : [],
                              onChanged: (dynamic value) =>
                                  BlocProvider.of<DropdownStatusBloc>(context)
                                      .add(SelectDataDropdown(value)),
                            ),
                          )
                        ],
                      );
                    else
                      return Container();
                  },
                ),
              ],
            ),
          );
        }
    );
  }
}
