import 'package:absenkuv3/Bloc/Dropdown/DropdownSalesBawahanBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

// ignore: must_be_immutable
class DropdownSalesBawahan extends StatefulWidget {
  String title;
  var color;
  double fontSize;
  String? initialData;
  double? formHeight;
  double marginHorizontal;
  DropdownSalesBawahan(this.title, {this.initialData, this.color = Colors.grey, this.fontSize = 14, this.formHeight, this.marginHorizontal = 0});

  @override
  _DropdownSalesBawahanState createState() => _DropdownSalesBawahanState();
}

class _DropdownSalesBawahanState extends State<DropdownSalesBawahan> {
  TextEditingController _controller = TextEditingController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DropdownSalesBawahanBloc>(context).add(GetDataDropdownSalesBawahan(""));
  }

  @override
  Widget build(BuildContext context) {
    if(widget.initialData != null){
      _controller.text = widget.initialData!;
    }
    return Container(
      margin: EdgeInsets.only(bottom: 12, top: 0, right: widget.marginHorizontal, left: widget.marginHorizontal),
      child: BlocBuilder<DropdownSalesBawahanBloc, DropdownSalesBawahanState>(
        builder: (BuildContext context, DropdownSalesBawahanState state){
          if(state is DropdownSalesBawahanSuccessState) return Container(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                SizedBox(height: 7),
                DropdownMenu(
                  dropdownMenuEntries: state.dropdownRespon.data!.map((item) {
                    return DropdownMenuEntry(
                        value: item,
                        label: item.nama!
                    );
                  }).toList(),
                  selectedTrailingIcon: Container(child: Text("")),
                  inputDecorationTheme: InputDecorationTheme(
                    contentPadding: EdgeInsets.symmetric(vertical: 7.0),
                    enabledBorder: UnderlineInputBorder(borderSide: BorderSide(color: CustomStyle.colorLineFormDropdown)),
                  ),
                  controller: _controller,
                  onSelected: (value)=>BlocProvider.of<DropdownSalesBawahanBloc>(context).add(SelectDataDropdownSalesBawahan(value!)),
                  label: Row(
                    children: [
                      Text(widget.title, style: TextStyle( fontSize: _controller.text.isEmpty?widget.fontSize:17, fontWeight: FontWeight.w400)),
                      SizedBox(width: 7),
                      Text('*', style: TextStyle(color: Colors.red, fontSize: widget.fontSize)),
                    ],
                  ),
                  textStyle: TextStyle(fontSize: 13),
                  requestFocusOnTap: false,
                  width: MediaQuery.of(context).size.width-50,
                ),
              ],
            ),
          );
          else return Container(
            height: widget.formHeight??CustomStyle.formHeight,
            width: MediaQuery.of(context).size.width,
            child: Shimmer.fromColors(
              baseColor: Colors.grey[200]!,
              highlightColor: Colors.white,
              period: Duration(seconds: 4),
              child: Card(),
            ),
          );
        },
      ),
    );
  }
}
