import 'package:absenkuv3/Bloc/Cuti/GetDataCutiBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mCutiPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Cuti/komponen/KomponenCuti.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanCuti extends StatefulWidget {
  const HalamanCuti({super.key});

  @override
  State<HalamanCuti> createState() => _HalamanCutiState();
}

class _HalamanCutiState extends State<HalamanCuti> {
  @override
  void initState() {
    super.initState();
    BlocProvider.of<DataCutiBloc>(context).add(GetDataCuti());
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageCutiModel>(
      future: PengaturanBahasa().cuti(),
      builder: (BuildContext context, snapshot) {
        if (snapshot.connectionState == ConnectionState.done) {
          return Scaffold(
            backgroundColor: Colors.white,
            appBar: AppBar(
              flexibleSpace: Image(
                image: AssetImage(ValueImage.headerBiruDashboard),
                fit: BoxFit.cover,
              ),
              backgroundColor: Colors.transparent,
              centerTitle: true,
              title: Text(
                snapshot.data!.menuCuti!.title!.titleCuti!,
                style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
              ),
            ),
            body: BlocBuilder<DataCutiBloc, DataCutiState>(
                builder: (BuildContext context, DataCutiState state) {
              if (state is DataCutiSuccessState) {
                return Column(
                  children: [
                    Stack(
                      children: [
                        Container(
                          color: CustomStyle.color1,
                          height: 80,
                        ),
                        Container(
                          child: Column(
                            children: [
                              Container(
                                width: MediaQuery.sizeOf(context).width,
                                margin: EdgeInsets.fromLTRB(15, 45, 15, 10),
                                decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.circular(10),
                                  border: Border.all(
                                    color: Colors.grey.shade200,
                                  ),
                                ),
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Container(
                                      margin: EdgeInsets.all(10),
                                      child: Row(
                                        mainAxisAlignment:
                                            MainAxisAlignment.spaceBetween,
                                        children: [
                                          Text(snapshot
                                              .data!.menuCuti!.data!.saldoCuti
                                              .toString()),
                                          Text(
                                            state.respon.data!.sisaCuti
                                                .toString(),
                                            style: TextStyle(
                                                fontWeight: FontWeight.bold),
                                          )
                                        ],
                                      ),
                                    ),
                                    Container(
                                      margin: EdgeInsets.all(10),
                                      child: Row(
                                        mainAxisAlignment:
                                            MainAxisAlignment.spaceBetween,
                                        children: [
                                          Text(snapshot.data!.menuCuti!.data!
                                              .berlakuHingga
                                              .toString()),
                                          Text(
                                              state.respon.data!
                                                  .cutiBerlakuHingga
                                                  .toString(),
                                              style: TextStyle(
                                                  fontWeight: FontWeight.bold))
                                        ],
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                              Container(
                                // padding: EdgeInsets.all(22),
                                child: Column(
                                  children: [
                                    SizedBox(
                                      height: 20,
                                    ),
                                    CardTitleCuti(
                                      Title: snapshot
                                          .data!.menuCuti!.data!.sudahDigunakan
                                          .toString(),
                                      Subtitle: snapshot
                                          .data!.menuCuti!.data!.riwayatCuti
                                          .toString(),
                                      Total: state.respon.data!.totalKurang
                                          .toString(),
                                      ColorDecor: Colors.red,
                                      OnClick: () {
                                        BlocProvider.of<NavigatorBloc>(context)
                                            .add(
                                                NavigateToHalamanListHistoryCuti(
                                                    context, [
                                          'kurang',
                                          state.respon.data!.periodeAwalCuti,
                                          state.respon.data!.periodeAkhirCuti
                                        ]));
                                      },
                                    ),
                                    Divider(),
                                    CardTitleCuti(
                                      Title: snapshot
                                          .data!.menuCuti!.data!.diTambahkan
                                          .toString(),
                                      Subtitle: snapshot
                                          .data!.menuCuti!.data!.riwayatSaldo
                                          .toString(),
                                      Total: state.respon.data!.totalTambah
                                          .toString(),
                                      ColorDecor: Colors.green,
                                      OnClick: () {
                                        BlocProvider.of<NavigatorBloc>(context)
                                            .add(
                                                NavigateToHalamanListHistoryCuti(
                                                    context, [
                                          'tambah',
                                          state.respon.data!.periodeAwalCuti,
                                          state.respon.data!.periodeAkhirCuti
                                        ]));
                                      },
                                    )
                                  ],
                                ),
                              )
                            ],
                          ),
                        )
                      ],
                    ),
                  ],
                );
              } else if (state is DataCutiProggres) {
                return Container(
                    height: MediaQuery.of(context).size.height,
                    child: Center(
                        child: CircularProgressIndicator(
                      strokeWidth: 8,
                    )));
              } else {
                return Container(
                  alignment:
                      Alignment.center, // Pusatkan konten di dalam Container
                  child: Column(
                    mainAxisAlignment:
                        MainAxisAlignment.center, // Pusatkan secara vertikal
                    crossAxisAlignment:
                        CrossAxisAlignment.center, // Pusatkan secara horizontal
                    children: [
                      Image.asset(
                        ValueImage.noData,
                        height: 250,
                      ),
                      Text('Pengaturan cuti belum di setting Admin')
                    ],
                  ),
                );
              }
            }),
          );
        } else {
          return Container();
        }
      },
    );
  }
}
