import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mBerita.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_html/flutter_html.dart';

class CardBerita extends StatefulWidget {
  final DataBerita dataBerita;
  final GlobalKey<ScaffoldState> scaffoldKey;
  CardBerita(this.dataBerita, this.scaffoldKey);

  @override
  _CardBeritaState createState() => _CardBeritaState();
}

class _CardBeritaState extends State<CardBerita> {
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () => BlocProvider.of<NavigatorBloc>(context)
          .add(NavigateToDetailBerita(context, [widget.dataBerita.idBerita,'komponen'])),
      child: Container(
        decoration: CustomStyle.boxDecoration,
        padding: EdgeInsets.all(14),
        margin: EdgeInsets.only(top: 12, left: 12, right: 12),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              children: [
                Icon(
                  Icons.new_releases_outlined,
                  size: 32,
                  color: CustomStyle.color1,
                ),
                SizedBox(
                  width: 8,
                ),
                Expanded(
                    child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      widget.dataBerita.judul!,
                      style: TextStyle(
                          fontSize: CustomStyle.fontSizeSmall + 1,
                          fontWeight: FontWeight.w600,
                          color: CustomStyle.fontColorBlack),
                    ),
                    SizedBox(
                      height: 2,
                    ),
                    Text(
                      '${widget.dataBerita.tanggalCreated}, ${widget.dataBerita.waktuCreated}',
                      style: TextStyle(
                          fontSize: CustomStyle.fontSizeSmall - 1,
                          color: CustomStyle.fontColorGrey,
                          fontWeight: FontWeight.w600),
                    ),
                  ],
                )),
                SizedBox(
                  width: 12,
                ),
                PopupMenuButton<String>(
                  onSelected: (value) {
                    if (value == 'Detail')
                      BlocProvider.of<NavigatorBloc>(context).add(
                          NavigateToDetailBerita(
                              context, [widget.dataBerita.idBerita]));
                  },
                  itemBuilder: (BuildContext context) {
                    return actionMenu();
                  },
                  child: Icon(
                    Icons.more_vert_sharp,
                    color: CustomStyle.fontColorGrey,
                  ),
                )
              ],
            ),
            SizedBox(
              height: 6,
            ),
            Divider(
              thickness: 1,
            ),
            Html(
              data: widget.dataBerita.content!.length > 140
                  ? widget.dataBerita.content!.substring(0, 140) + '..'
                  : widget.dataBerita.content,
              style: {
                "p": Style(
                  padding: HtmlPaddings.zero,
                  margin: Margins.zero,
                ),
              },
            )
          ],
        ),
      ),
    );
  }

  actionMenu() {
    return {'Detail'}.map((String choice) {
      return PopupMenuItem<String>(
        value: choice,
        child: Text(choice),
      );
    }).toList();
  }
}

class TemplateRow extends StatelessWidget {
  final String title;
  final String subTitle;
  final Color color;
  final String imageUrl;
  TemplateRow(this.title, this.subTitle, this.imageUrl, this.color);

  @override
  Widget build(BuildContext context) {
    return Row(
      children: [
        Expanded(
          flex: 4,
          child: Text(
            title,
            style: TextStyle(
                fontWeight: FontWeight.w600,
                color: color,
                fontSize: CustomStyle.fontSizeSmall - 1),
          ),
        ),
        SizedBox(
          width: 12,
        ),
        Expanded(
          flex: 7,
          child: Text(
            subTitle,
            style: TextStyle(
                color: CustomStyle.fontColorBlack,
                fontSize: CustomStyle.fontSizeSmall - 1),
          ),
        ),
        SizedBox(
          width: 12,
        ),
        Expanded(
          flex: 1,
          child: imageUrl.isNotEmpty
              ? GestureDetector(
                  onTap: () => BlocProvider.of<NavigatorBloc>(context)
                      .add(NavigateToDetailImageClicked(context, imageUrl)),
                  child: Icon(
                    Icons.image,
                    color: Colors.grey[500],
                    size: 22,
                  ))
              : Container(),
        ),
      ],
    );
  }
}
