import 'package:absenkuv3/Bloc/Berita/BeritaBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/UI/templateDateRangePicker.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import 'KomponenBerita.dart';



class HalamanListBerita extends StatefulWidget {
  @override
  _HalamanListBeritaState createState() => _HalamanListBeritaState();
}

class _HalamanListBeritaState extends State<HalamanListBerita> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  ModelFilter? modelFilter;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(InitialDate());
    BlocProvider.of<BeritaBloc>(context).add(getListBeritaEvent(context, null));
    _scrollController.addListener(()=>BlocProvider.of<BeritaBloc>(context).add(loadMoreEvent(context, scaffoldKey, _scrollController)));
  }
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: Stack(
        children: [
          BlocBuilder<BeritaBloc, BeritaState>(
              builder: (BuildContext context, BeritaState state){
                if(state is getListBeritaSuccessState || state is LoadMoreProgressState)
                  return Stack(
                    children: <Widget>[
                      ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          controller: _scrollController,
                          itemCount: state.data!.length,
                          itemBuilder: (BuildContext context, index) {
                            return CardBerita(state.data![index],scaffoldKey);
                          }
                      ),
                      state is LoadMoreProgressState? Positioned(
                          bottom :16,
                          child: Container(
                              width: MediaQuery.of(context).size.width,
                              child: Center(child: CircularProgressIndicator(strokeWidth: 8,)))):Container(),
                    ],
                  );
                else if(state is BeritaProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
              }),
          Positioned(
            bottom: 16,
            right: 14,
            child: BlocListener<DateRangePickerBloc, DateRangePickerState>(
              listener: (BuildContext context, DateRangePickerState dateRangePickerState){
                if(dateRangePickerState is DateAvailable) BlocProvider.of<BeritaBloc>(context).add(getListBeritaEvent(context, ModelFilter(dateRange: dateRangePickerState.date)));
              },
              child: TemplateDateRangePicker(),
            ),
          )
        ],
      ),
    );
  }
}


