import 'package:absenkuv3/Bloc/Berita/DetailBeritaBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/NotifBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mBeritaPengumumanPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_html/flutter_html.dart';

class HalamanDetailBerita extends StatefulWidget {
  var data;
  HalamanDetailBerita(this.data);
  @override
  _HalamanDetailBeritaState createState() => _HalamanDetailBeritaState();
}

class _HalamanDetailBeritaState extends State<HalamanDetailBerita> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
    bool refresh = false;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DetailBeritaBloc>(context)
        .add(GetDetailBerita(widget.data[0]));
    BlocProvider.of<NotifBloc>(context).add(BacaNotif(widget.data[0], 'berita', context));
  }

  Future<bool> keluar() async {
      if(widget.data[1] == 'notif'){
        Navigator.pop(context, refresh);
      }else{
        BlocProvider.of<NavigatorBloc>(context).add(NavigatePop(context));
      }
      return false;
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageBeritaPengumumanModel>(
        future: PengaturanBahasa().beritaPengumuman(),
        builder: (context, snapshot) {
          return BlocListener<NotifBloc, NotifState>(
            listener: (context, stateNotifBloc) {
              if(stateNotifBloc is SuccessBacaNotifState){
                refresh = true;
              }
            },
            child: Scaffold(
                key: scaffoldKey,
                backgroundColor: Colors.white,
                appBar: AppBar(
                  flexibleSpace: Image(
                    image: AssetImage(ValueImage.headerBiruDashboard),
                    fit: BoxFit.cover,
                  ),
                  backgroundColor: Colors.transparent,
                  centerTitle: true,
                  title: Text(
                    snapshot.data == null ? 'News Details' : snapshot.data!.menuBeritaPengumuman!.detailBerita!,
                    style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                  ),
                ),
                body: BlocBuilder<DetailBeritaBloc, DetailBeritaState>(
                    builder: (BuildContext context, DetailBeritaState state) {
                      if (state is DetailBeritaSuccess)
                        return Stack(
                          children: [
                            Container(
                              height: double.infinity,
                              child: SingleChildScrollView(
                                child: Padding(
                                  padding: const EdgeInsets.fromLTRB(16, 18, 16, 16),
                                  child: Column(
                                    mainAxisSize: MainAxisSize.min,
                                    children: [
                                      Padding(
                                        padding:
                                        const EdgeInsets.only(bottom: 12, top: 6),
                                        child: SingleChildScrollView(
                                          child: Column(
                                            crossAxisAlignment: CrossAxisAlignment.start,
                                            children: [
                                              Row(
                                                children: [
                                                  Icon(
                                                    Icons.new_releases_outlined,
                                                    size: 32,
                                                    color: CustomStyle.color1,
                                                  ),
                                                  SizedBox(
                                                    width: 10,
                                                  ),
                                                  Expanded(
                                                      child: Column(
                                                        crossAxisAlignment:
                                                        CrossAxisAlignment.start,
                                                        children: [
                                                          Text(
                                                            state
                                                                .beritaRespon.data![0].judul!,
                                                            style: TextStyle(
                                                                fontSize: CustomStyle
                                                                    .fontSizeSmall +
                                                                    1,
                                                                fontWeight: FontWeight.w600,
                                                                color: CustomStyle
                                                                    .fontColorBlack),
                                                          ),
                                                          SizedBox(
                                                            height: 2,
                                                          ),
                                                          Text(
                                                            '${state.beritaRespon.data![0].tanggalCreated}, ${state.beritaRespon.data![0].waktuCreated}',
                                                            style: TextStyle(
                                                                fontSize: CustomStyle
                                                                    .fontSizeSmall -
                                                                    1,
                                                                color:
                                                                CustomStyle.fontColorGrey,
                                                                fontWeight: FontWeight.w600),
                                                          ),
                                                        ],
                                                      )),
                                                  SizedBox(
                                                    width: 12,
                                                  ),
                                                ],
                                              ),
                                              SizedBox(
                                                height: 6,
                                              ),
                                              Divider(
                                                thickness: 1,
                                              ),
                                              state.beritaRespon.data![0].gambar != '-'
                                                  ? GestureDetector(
                                                  onTap: () => BlocProvider.of<
                                                      NavigatorBloc>(context)
                                                      .add(
                                                      NavigateToDetailImageClicked(
                                                          context,
                                                          state.beritaRespon
                                                              .data![0].gambar)),
                                                  child: Image.network(
                                                    state.beritaRespon.data![0]
                                                        .gambar!,
                                                    width: MediaQuery.of(context)
                                                        .size
                                                        .width /
                                                        4,
                                                  ))
                                                  : Container(),
                                              Html(
                                                data: state.beritaRespon.data![0].content,
                                                style: {
                                                  "p": Style(
                                                    padding: HtmlPaddings.zero,
                                                    margin: Margins.zero,
                                                  ),
                                                },
                                              )
                                            ],
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            ),
                          ],
                        );
                      else if (state is DetailBeritaProgress)
                        return Container(
                            height: MediaQuery.of(context).size.height,
                            width: MediaQuery.of(context).size.width,
                            child: Center(
                                child: CircularProgressIndicator(
                                  strokeWidth: 8,
                                )));
                      else
                        return Container();
                    })),
          );
        }
      ),
    );
  }
}
