import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mKontakPegawai.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKontakPegawaiPage.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class CardListPegawai extends StatefulWidget {
  final DataKontak dataKontakPegawai;
  final GlobalKey<ScaffoldState> scaffoldKey;
  CardListPegawai(this.dataKontakPegawai, this.scaffoldKey);
  @override
  State<CardListPegawai> createState() => _CardListPegawaiState();
}

class _CardListPegawaiState extends State<CardListPegawai> {
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () {
        // Handle onTap event
      },
      child: SizedBox(
        // Wrap ListTile with SizedBox to specify width
        width: double.infinity,
        child: Container(
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              Divider(),
              ListTile(
                contentPadding: EdgeInsets.zero, // Remove default padding
                leading: Builder(
                  builder: (BuildContext context) {
                    return GestureDetector(
                      child: Container(
                        height: 46,
                        width: 46,
                        decoration: BoxDecoration(
                          color: Colors.grey[100],
                          borderRadius: BorderRadius.circular(120.0),
                        ),
                        child: ClipRRect(
                          borderRadius: BorderRadius.circular(120.0),
                          child: Center(
                            child: widget.dataKontakPegawai.foto != '-'
                                ? Image.network(
                                    widget.dataKontakPegawai.foto!,
                                    height: 46,
                                    width: 46,
                                    fit: BoxFit.cover,
                                    errorBuilder: (c, obj, st) {
                                      return Icon(
                                        Icons.person,
                                        color: Colors.grey[400],
                                        size: 46,
                                      );
                                    },
                                  )
                                : Icon(
                                    Icons.person,
                                    color: Colors.grey[400],
                                    size: 46,
                                  ),
                          ),
                        ),
                      ),
                      onTap: () {
                        // Handle onTap event
                      },
                    );
                  },
                ),
                title: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      widget.dataKontakPegawai.namaLengkap.toString(),
                      style: TextStyle(fontSize: CustomStyle.fontSizeSmall),
                    ),
                    Text(
                      widget.dataKontakPegawai.nik.toString(),
                      style: TextStyle(
                        fontSize: CustomStyle.fontSizeSmall,
                        color: Colors.grey,
                      ),
                    ),
                  ],
                ),
                onTap: () {
                  // Handle onTap event
                },
                trailing: Icon(
                  Icons.arrow_forward_ios,
                  size: 20,
                  color: Colors.blueAccent,
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}

// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables

class ListCard extends StatefulWidget {
  final DataKontak dataKontakPegawai;
  final GlobalKey<ScaffoldState> scaffoldKey;
  MenuDataKontakPegawai? redaksional;
  ListCard(this.dataKontakPegawai, this.scaffoldKey, this.redaksional);

  @override
  State<ListCard> createState() => _ListCardState();
}

class _ListCardState extends State<ListCard> {
  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        Container(
          child: ListTile(
            // dense: true,
            title: Text(
              '${widget.dataKontakPegawai.namaLengkap}',
              style: TextStyle(
                  fontSize: 15,
                  color: Colors.black,
                  fontWeight: FontWeight.bold),
            ),
            subtitle: Text('${widget.dataKontakPegawai.nik}',
                style: TextStyle(
                    fontSize: 13,
                    color: Color(0xff003786),
                    fontWeight: FontWeight.bold)),
            leading: FractionallySizedBox(
              child: Builder(
                builder: (BuildContext context) {
                  return GestureDetector(
                    child: Container(
                      height: 46,
                      width: 46,
                      decoration: BoxDecoration(
                        border: Border.all(color: Colors.grey.shade100),
                        borderRadius: BorderRadius.circular(120.0),
                      ),
                      child: ClipRRect(
                        borderRadius: BorderRadius.circular(120.0),
                        child: Container(
                            child: widget.dataKontakPegawai.foto != '-'
                                ? Image.network(
                                    widget.dataKontakPegawai.foto!,
                                    height: 46,
                                    width: 46,
                                    fit: BoxFit.cover,
                                    errorBuilder: (c, obj, st) {
                                      return
                                          // Icon(
                                          //   Icons.person,
                                          //   color: Colors.grey[400],
                                          //   size: 46,
                                          // );
                                          Image.asset(
                                        ValueImage.iconUserEmpty,
                                        fit: BoxFit.fill,
                                      );
                                    },
                                  )
                                :
                                Image.asset(
                                        ValueImage.iconUserEmpty,
                                        fit: BoxFit.fill,
                                      )),
                      ),
                    ),
                    // onTap: () {
                      onTap: ()=>BlocProvider.of<NavigatorBloc>(context)
                        .add(NavigateToDetailImageClicked(context, widget.dataKontakPegawai.foto))
                    // },
                  );
                },
              ),
            ),
            onTap: () {
              BlocProvider.of<NavigatorBloc>(context).add(
                  NavigateToDetailKontakPegawai(
                      context, [widget.dataKontakPegawai, widget.redaksional]));
            },
            trailing: Icon(
              Icons.arrow_forward_ios,
              size: 20,
              color: Colors.blueAccent,
            ),
          ),
        )
      ],
    );
  }
}
