import 'package:absenkuv3/Bloc/Akun/DataPendidikan/DataPendidikanBloc.dart';
import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownAsalLulusanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownJenjangBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/DataPendidikan/mDataPendidikan.dart';
import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataPendidikanPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisAsalLulusan.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisJenjang.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetJenisAsalLulusan.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetJenisJenjang.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Bloc/MultiImagePicker2Bloc.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Bloc/MultiImagePickerBloc.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel2.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/UI/templateMultiImagePicker.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/UI/templateMultiImagePicker2.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateTextFormAkun.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

// ignore: must_be_immutable
class HalamanAddDataPendidikan extends StatefulWidget {

  @override
  _HalamanAddDataPendidikanState createState() => _HalamanAddDataPendidikanState();
}

class _HalamanAddDataPendidikanState extends State<HalamanAddDataPendidikan> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  String? idPendidikan;
  JenisData? jenjangPendidikan;
  TextEditingController jurusan = new TextEditingController();
  TextEditingController namaSeklolah = new TextEditingController();
  TextEditingController tanggalMasuk = new TextEditingController();
  TextEditingController tanggalLulus = new TextEditingController();
  TextEditingController gelar = new TextEditingController();
  JenisData? lulusanAsal;

  List<MultiImagePickerModel>? listImageIjazah;
  List<MultiImagePickerModel2>? listImageTranskrip;


  Future<bool> keluar() async {
    Navigator.pop(context);
    return false;
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataPendidikanModel>(
        future: PengaturanBahasa().dataPendidikan(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return Scaffold(
                key: scaffoldKey,
                appBar: AppBar(centerTitle: true,
                  iconTheme: IconThemeData(color: CustomStyle.color15),
                  flexibleSpace: Image(
                    image: AssetImage(ValueImage.headerBiruDashboard),
                    fit: BoxFit.cover,
                  ),
                  backgroundColor: Colors.transparent,
                  title: Text(snapshot.data!.menuDataPendidikan!.addTitle!,
                    style: TextStyle(fontSize: CustomStyle.fontSizeTitle, color: CustomStyle.color15),
                  ),
                ),
                body: SingleChildScrollView(
                  child: Container(
                    margin: EdgeInsets.all(10),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        BlocListener<DropdownJenjangBloc, DropdownJenjangState>(
                          listener: (BuildContext context, DropdownJenjangState state) {
                            if (state is DropdownJenjangSuccessState && state.selectedValue != null) {
                              jenjangPendidikan = state.selectedValue;
                            }
                          },
                          child: BottomSheetJenisJenjang(
                            snapshot.data!.menuDataPendidikan!.dataPendidikan!.jenjangPendidikan!,
                            initialData: jenjangPendidikan == null ? null : jenjangPendidikan!.nama,
                            color: Colors.black,
                            marginHorizontal: 13,
                          ),
                        ),
                        SizedBox(height: 17),
                        TemplateTextFormAkun(
                          adaValidasi: false,
                          controller: jurusan,
                          color: Colors.black,
                          fontSize: 13,
                          titleText: snapshot.data!.menuDataPendidikan!.dataPendidikan!.jurusan,
                          radius: CustomStyle.formRadius,
                          marginHorizontal: 13,
                          // hintText: "Jurusan",
                        ),
                        SizedBox(height: 17),
                        TemplateTextFormAkun(
                          adaValidasi: true,
                          controller: namaSeklolah,
                          color: Colors.black,
                          fontSize: 13,
                          marginHorizontal: 13,
                          titleText: snapshot.data!.menuDataPendidikan!.dataPendidikan!.namaSekolah,
                          radius: CustomStyle.formRadius,
                          // hintText: "Nama Sekolah",
                        ),
                        SizedBox(height: 17),
                        TemplateTextFormAkun(
                          adaValidasi: true,
                          controller: tanggalMasuk,
                          keyboardNumber: true,
                          color: Colors.black,
                          fontSize: 13,
                          titleText: snapshot.data!.menuDataPendidikan!.dataPendidikan!.tahunMasuk,
                          radius: CustomStyle.formRadius,
                          marginHorizontal: 13,
                          // hintText: "Tahun Masuk",
                        ),
                        SizedBox(height: 17),
                        TemplateTextFormAkun(
                          adaValidasi: true,
                          controller: tanggalLulus,
                          keyboardNumber: true,
                          color: Colors.black,
                          fontSize: 13,
                          titleText: snapshot.data!.menuDataPendidikan!.dataPendidikan!.tahunLulus,
                          radius: CustomStyle.formRadius,
                          marginHorizontal: 13,
                          // hintText: "Tahun Lulus",
                        ),
                        BlocListener<DropdownAsalLulusanBloc, DropdownAsalLulusanState>(
                          listener: (BuildContext context, DropdownAsalLulusanState state) {
                            if (state is DropdownAsalLulusanSuccessState && state.selectedValue != null) {
                              lulusanAsal = state.selectedValue;
                            }
                          },
                          child: BottomSheetJenisAsalLulusan(
                            snapshot.data!.menuDataPendidikan!.dataPendidikan!.lulusanAsal!,
                            initialData: lulusanAsal == null ? null : lulusanAsal!.nama,
                            marginHorizontal: 13,
                          ),
                        ),
                        SizedBox(height: 17),
                        TemplateTextFormAkun(
                          adaValidasi: false,
                          controller: gelar,
                          color: Colors.black,
                          fontSize: 13,
                          titleText: snapshot.data!.menuDataPendidikan!.dataPendidikan!.gelar,
                          radius: CustomStyle.formRadius,
                          marginHorizontal: 13,
                          // hintText: "Gelar",
                        ),
                        Container(
                            margin: EdgeInsets.only(bottom: 9, right: 13, left: 13, top: 17),
                            child: Row(
                              children: [
                                Text(snapshot.data!.menuDataPendidikan!.dataPendidikan!.lampiranIjasah!,style: TextStyle(color: Colors.grey[600])),
                                // Container(
                                //   margin: EdgeInsets.only(left: 5),
                                //   child: Text(
                                //     '*',
                                //     style: TextStyle(color: Colors.red, fontWeight: FontWeight.bold, fontSize: 13),
                                //   ),
                                // ),
                              ],
                            )),
                        BlocListener<MultiImagePickerBloc, MultiImagePickerState>(
                          listener: (BuildContext context, MultiImagePickerState state) {
                            if (state is MultiImageSuccessState)
                              listImageIjazah = state.listData;
                          },
                          child: Container(
                              margin: EdgeInsets.only(left: 15, right: 15),
                              child: TemplateMultiImagePicker(multiImage: false)),
                        ),

                        Container(
                            margin: EdgeInsets.only(bottom: 9, right: 13, left: 13, top: 17),
                            child: Row(
                              children: [
                                Text(snapshot.data!.menuDataPendidikan!.dataPendidikan!.lampiranTranskrip!,style: TextStyle(color: Colors.grey[600])),
                                // Container(
                                //   margin: EdgeInsets.only(left: 5),
                                //   child: Text(
                                //     '*',
                                //     style: TextStyle(color: Colors.red, fontWeight: FontWeight.bold, fontSize: 13),
                                //   ),
                                // ),
                              ],
                            )),
                        BlocListener<MultiImagePicker2Bloc, MultiImagePicker2State>(
                          listener:
                              (BuildContext context, MultiImagePicker2State state) {
                            if (state is MultiImageSuccess2State)
                              listImageTranskrip = state.listData;
                          },
                          child: Container(
                              margin: EdgeInsets.only(left: 15, right: 15),
                              child: TemplateMultiImagePicker2(multiImage: false)),
                        ),
                        Container(
                          margin: EdgeInsets.only(top: 15),
                          width: double.infinity,
                          height: 41,
                          child: MaterialButton(onPressed: () {
                            if(jenjangPendidikan == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataPendidikan!.message!.jenjangPendidikanEmpty, context);
                            else if(namaSeklolah.text.trim().isEmpty) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataPendidikan!.message!.namaSekolahEmpty, context);
                            else if(tanggalMasuk.text.trim().isEmpty) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataPendidikan!.message!.tahunMasuk, context);
                            else if(tanggalLulus.text.trim().isEmpty) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataPendidikan!.message!.tahunLulus, context);
                            else
                              BlocProvider.of<DataPendidikanBloc>(context).add(
                                  PengajuanTambahDataPendidikanEvent(
                                      context,
                                      scaffoldKey,
                                      DataDatapendidikan(
                                          jenjang: jenjangPendidikan!.nama,
                                          jurusan: jurusan.text,
                                          namaSekolah: namaSeklolah.text,
                                          tahunMasuk: tanggalMasuk.text,
                                          tahunLulus: tanggalLulus.text,
                                          lulusanAsal: lulusanAsal!.nama,
                                          gelar: gelar.text
                                      ),
                                      listImageIjazah,
                                      listImageTranskrip
                                  ));
                          },
                            shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(15)
                            ),
                            color: CustomStyle.color1,
                            textColor: Colors.white,
                            child: Text(snapshot.data!.menuDataPendidikan!.button!.ajukanData!),
                          ),
                        )
                      ],
                    ),
                  ),
                )
            );
          }else{
            return Container();
          }
        }
      ),
    );
  }
}
