import 'package:absenkuv3/Bloc/Akun/StatusPengajuanDataBloc.dart';
import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mStatusPengajuan.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKeluargaPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataKeluarga/HalamanDataKeluargaPengajuan.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataKeluarga/HalamanDataKeluargaTerverifikasi.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class ParentTabDataKeluarga extends StatefulWidget {
  var initialIndex;

  ParentTabDataKeluarga(this.initialIndex);

  @override
  _ParentTabDataKeluargaState createState() => _ParentTabDataKeluargaState();
}

class _ParentTabDataKeluargaState extends State<ParentTabDataKeluarga> {
  int tabLength = 2;
  StatusPengajuanDataRespon? dataStatusPengajuan;

  Future<bool> keluar() async {
    Navigator.pop(context);
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateToRepaceHalamanAkun(context));
    return false;
  }

  @override
  void initState() {
    super.initState();
    BlocProvider.of<StatusPengajuanDataBloc>(context).add(getStatusPengajuanDataEvent(context));
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataKeluargaModel>(
        future: PengaturanBahasa().dataKeluarga(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return BlocBuilder<StatusPengajuanDataBloc, StatusPengajuanDataState>(
                builder: (BuildContext context, StatusPengajuanDataState state) {
                  if(state is getStatusPengajuanDataSuccessState){
                    dataStatusPengajuan = state.listStatusPengajuanData;
                    if(dataStatusPengajuan!.statusDataKeluarga == false){
                      widget.initialIndex = 0;
                    }
                  }
                  return DefaultTabController(
                    length: tabLength,
                    initialIndex: widget.initialIndex,
                    child: BlocBuilder<AuthBloc, LoginRespon>(
                      builder: (context, stateLogin) {
                        return Scaffold(
                          appBar: AppBar(
                            centerTitle: true,
                            iconTheme: IconThemeData(color: CustomStyle.color15),
                            flexibleSpace: Image(
                              image: AssetImage(ValueImage.headerBiruDashboard),
                              fit: BoxFit.cover,
                            ),
                            backgroundColor: Colors.transparent,
                            title: Text(snapshot.data!.menuDataKeluarga!.title!, style: TextStyle(fontSize: CustomStyle.fontSizeTitle,color: CustomStyle.color15)),
                            bottom: dataStatusPengajuan == null ? null : dataStatusPengajuan!.statusDataKeluarga == false ? null : TabBar(
                              labelPadding: EdgeInsets.all(0),
                              indicatorSize: TabBarIndicatorSize.tab,
                              labelColor: CustomStyle.color15,
                              indicatorColor: Colors.white,
                              indicatorWeight: 4,
                              isScrollable: true,
                              tabs: [
                                Container(
                                    width: MediaQuery.of(context).size.width / tabLength,
                                    child: Tab(text: snapshot.data!.menuDataKeluarga!.terverifikasi)),
                                Container(
                                    width: MediaQuery.of(context).size.width / tabLength,
                                    child: Tab(text: snapshot.data!.menuDataKeluarga!.pengajuan)),
                              ],
                            ),
                            actions: stateLogin.dataLogin!.komponenMobile![9] == '0' ? null : [
                              GestureDetector(
                                onTap: () => BlocProvider.of<NavigatorBloc>(context)
                                    .add(NavigateToHalamanAddDataKeluarga(context)),
                                child: Container(
                                    margin: EdgeInsets.only(right: 14),
                                    child: Icon(
                                      Icons.add,
                                      size: 26,
                                    )),
                              ),
                            ],
                          ),
                          body: TabBarView(
                            physics: NeverScrollableScrollPhysics(),
                            children: [
                              HalamanDataKeluargaTerverifikasi(snapshot.data!),
                              HalamanDataKeluargaPengajuan(snapshot.data!),
                            ],
                          ),
                        );
                      }
                    ),
                  );
                }
            );
          }else{
            return Container();
          }
        }
      ),
    );
  }
}
