import 'package:absenkuv3/Bloc/Akun/NotifikasiAkunBloc.dart';
import 'package:absenkuv3/Bloc/Akun/StatusPengajuanDataBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mStatusPengajuan.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataDiriPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataDiri/HalamanDataDiri.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataDiri/HalamanPengajuanDataDiri.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

// ignore: must_be_immutable
class ParentTabDataDiri extends StatefulWidget {
  var initialIndex;
  ParentTabDataDiri(this.initialIndex);

  @override
  _ParentTabDataDiriState createState() => _ParentTabDataDiriState();
}

class _ParentTabDataDiriState extends State<ParentTabDataDiri> {
  int tabLength = 2;
  StatusPengajuanDataRespon? dataStatusPengajuan;

  Future<bool> keluar() async {
    Navigator.pop(context);
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateToRepaceHalamanAkun(context));
    return false;
  }

  @override
  void initState() {
    super.initState();
    BlocProvider.of<StatusPengajuanDataBloc>(context).add(getStatusPengajuanDataEvent(context));
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataDiriModel>(
        future: PengaturanBahasa().dataDiri(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return BlocBuilder<StatusPengajuanDataBloc, StatusPengajuanDataState>(
                builder: (BuildContext context, StatusPengajuanDataState state) {
                  if(state is getStatusPengajuanDataSuccessState){
                    dataStatusPengajuan = state.listStatusPengajuanData;
                  }
                  return DefaultTabController(
                    length: tabLength,
                    initialIndex: widget.initialIndex,
                    child: Scaffold(
                      appBar: AppBar(
                        centerTitle: true,
                        iconTheme: IconThemeData(color: CustomStyle.color15),
                        flexibleSpace: Image(
                          image: AssetImage(ValueImage.headerBiruDashboard),
                          fit: BoxFit.cover,
                        ),
                        backgroundColor: Colors.transparent,
                        title: Text(snapshot.data!.menuDataDiri!.title!, style: TextStyle(fontSize: CustomStyle.fontSizeTitle,color: CustomStyle.color15),),
                        bottom: dataStatusPengajuan == null ? null : dataStatusPengajuan!.statusPengajuanDataDiri == false ? null : TabBar(
                          labelPadding: EdgeInsets.all(0),
                          indicatorSize: TabBarIndicatorSize.tab,
                          indicatorWeight: 4,
                          labelColor: CustomStyle.color15,
                          isScrollable: true,
                          tabs: [
                            Container(
                              width: MediaQuery.of(context).size.width / tabLength,
                              child: Tab(
                                text: snapshot.data!.menuDataDiri!.terverifikasi,
                              ),
                            ),
                            Container(
                              width: MediaQuery.of(context).size.width / tabLength,
                              child: Tab(
                                text: snapshot.data!.menuDataDiri!.pengajuan,
                              ),
                            ),
                          ],
                        ),
                      ),
                      body: TabBarView(
                        physics: NeverScrollableScrollPhysics(),
                        children: [
                          HalamanDataDiri(),
                          HalamanPengajuanDataDiri(),
                          // Center(child: Text('Halaman pengajuan perubahan data diri'),),
                          // Center(child: Text('Halaman pengajuan perubahan data diri'),),
                        ],
                      ),
                    ),
                  );
                }
            );
          }else{
            return Container();
          }
        }
      )
    );
  }
}
