import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mAktivitasPage.dart';
import 'package:absenkuv3/Repository/Model/mAktivitas.dart';
import 'package:absenkuv3/UI/Template/halamanDetailMap.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/verticalDivider.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class CardAktivitas2 extends StatefulWidget {
  final DataAktivitas dataAktivitas;
  final GlobalKey<ScaffoldState> scaffoldKey;
  final String konteks;
  final PageAktivitasModel redaksional;
  CardAktivitas2(
      this.dataAktivitas, this.scaffoldKey, this.konteks, this.redaksional);

  @override
  _CardAktivitas2State createState() => _CardAktivitas2State();
}

class _CardAktivitas2State extends State<CardAktivitas2> {
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
        onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
            NavigateToDetailAktivitas(
                context, widget.dataAktivitas.idAktivitas)),
        child: Padding(
          padding: EdgeInsets.only(left: 10, right: 10, bottom: 10, top: 10),
          child: Container(
            margin: EdgeInsets.symmetric(vertical: 8),
            padding: EdgeInsets.all(16),
            decoration: BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.circular(12),
              boxShadow: [
                BoxShadow(
                  color: Colors.black.withOpacity(0.05),
                  blurRadius: 6,
                  offset: const Offset(0, 2),
                ),
              ],
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          widget.redaksional.menuAktivitas!.data!.tanggal!,
                          style: TextStyle(
                            fontSize: 12,
                            color: Colors.black54,
                          ),
                        ),
                        SizedBox(height: 4),
                        Text(
                          widget.dataAktivitas.tanggalRaw!,
                          style: const TextStyle(
                            fontSize: 14,
                            fontWeight: FontWeight.w600,
                          ),
                        ),
                      ],
                    ),
                    Container(
                      padding:
                          EdgeInsets.symmetric(horizontal: 12, vertical: 6),
                      decoration: BoxDecoration(
                        color: Color(0xFF1E2EFF), // biru gelap
                        borderRadius: BorderRadius.circular(20),
                      ),
                      child: Text(
                        widget.dataAktivitas.waktu!,
                        style: TextStyle(
                          color: Colors.white,
                          fontWeight: FontWeight.bold,
                          fontSize: 12,
                        ),
                      ),
                    ),
                  ],
                ),
                Divider(height: 24),
                // Keterangan
                Container(
                  width: double.infinity,
                  padding: const EdgeInsets.all(12),
                  decoration: BoxDecoration(
                    color: const Color(0xFFF2F2F5),
                    borderRadius: BorderRadius.circular(10),
                  ),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        widget.redaksional.menuAktivitas!.data!.keterangan!,
                        style: TextStyle(
                          fontSize: 12,
                          color: Colors.black45,
                        ),
                      ),
                      const SizedBox(height: 6),
                      Text(
                        widget.dataAktivitas.keterangan ??
                            'Tidak ada keterangan',
                        maxLines: 1,
                        overflow: TextOverflow.ellipsis,
                        style: const TextStyle(
                          fontSize: 14,
                          color: Colors.black87,
                        ),
                      ),
                    ],
                  ),
                ),
              ],
            ),
          ),
        ));
  }

  actionMenu() {
    return {'Detail'}.map((String choice) {
      return PopupMenuItem<String>(
        value: choice,
        child: Text(choice),
      );
    }).toList();
  }
}

class TemplateRow extends StatelessWidget {
  final String title;
  final String? subTitle;
  final Color? color;
  final String? imageUrl;
  final bool titikDua;
  final fontSize;
  final List<int>? flex;
  final String? lat;
  final String? long;
  TemplateRow(this.title, this.subTitle, this.imageUrl, this.color,
      {this.fontSize,
      this.flex,
      this.titikDua = false,
      this.lat = '-',
      this.long = '-'});

  @override
  Widget build(BuildContext context) {
    return Row(
      children: [
        Expanded(
          flex: flex != null ? flex![0] : 4,
          child: Text(
            title,
            style: TextStyle(
                fontWeight: FontWeight.w600,
                color: color,
                fontSize: fontSize ?? CustomStyle.fontSizeSmall - 1),
          ),
        ),
        SizedBox(
          width: 12,
        ),
        titikDua
            ? Row(
                children: [
                  SizedBox(
                    width: 12,
                  ),
                  Text(
                    ":",
                    style: TextStyle(
                        color: CustomStyle.fontColorBlack,
                        fontSize: fontSize ?? CustomStyle.fontSizeSmall - 1),
                  ),
                  SizedBox(
                    width: 12,
                  ),
                ],
              )
            : Container(),
        Expanded(
          flex: flex != null ? flex![1] : 7,
          child: Container(
            color: Colors.white,
            child: Text(
              subTitle!,
              style: TextStyle(
                  color: CustomStyle.fontColorBlack,
                  fontSize: fontSize ?? CustomStyle.fontSizeSmall - 1),
            ),
          ),
        ),
        SizedBox(
          width: 8,
        ),
        imageUrl != null
            ? Expanded(
                flex: flex != null ? flex![2] : 1,
                child: imageUrl != null
                    ? GestureDetector(
                        onTap: () => BlocProvider.of<NavigatorBloc>(context)
                            .add(NavigateToDetailImageClicked(
                                context, imageUrl)),
                        child: Icon(
                          Icons.image,
                          color: Colors.grey[500],
                          size: 22,
                        ))
                    : Container(),
              )
            : Container(),
        SizedBox(
          width: 8,
        ),
        Expanded(
          flex: 1,
          child: lat != '-' && lat != null
              ? GestureDetector(
                  onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
                      NavigateToDetailMap(
                          context,
                          ModelDetailMap("Lokasi Absen $title",
                              double.parse(lat!), double.parse(long!)))),
                  child: Icon(
                    Icons.pin_drop_rounded,
                    color: Colors.redAccent,
                    size: 21,
                  ))
              : Container(),
        ),
      ],
    );
  }
}
